/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.BehaviourOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;

public class UpdateModuleOperation
extends BehaviourOperation {
    public UpdateModuleOperation(CloudFoundryServerBehaviour behaviour, IModule module) {
        super(behaviour, module);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        if (this.getModule() == null) {
            throw CloudErrorUtil.toCoreException("Internal Error: No module to update in - " + this.getBehaviour().getCloudFoundryServer().getServerId());
        }
        CloudFoundryApplicationModule appModule = null;
        if (this.shouldUpdateInServer() && (appModule = this.updateModule(monitor)) != null) {
            appModule.setStatus(null);
            appModule.validateDeploymentInfo();
        }
        ServerEventHandler.getDefault().fireApplicationRefreshed(this.getBehaviour().getCloudFoundryServer(), this.getModule());
    }

    protected CloudFoundryApplicationModule updateModule(IProgressMonitor monitor) throws CoreException {
        return this.getBehaviour().updateModuleWithAllCloudInfo(this.getModule(), monitor);
    }

    protected boolean shouldUpdateInServer() {
        try {
            if (this.getBehaviour().getCloudFoundryServer().getServer() instanceof Server) {
                Server server = (Server)this.getBehaviour().getCloudFoundryServer().getServer();
                return 1 != server.getModuleState(new IModule[]{this.getModule()});
            }
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
        }
        return true;
    }
}

