/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.EditorAction;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.cft.server.ui.internal.editor.ServicesHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class DeleteServicesAction
extends EditorAction {
    private final CloudFoundryServerBehaviour serverBehaviour;
    private final ServicesHandler servicesHandler;

    public DeleteServicesAction(IStructuredSelection selection, CloudFoundryServerBehaviour serverBehaviour, CloudFoundryApplicationsEditorPage editorPage) {
        super(editorPage, EditorAction.RefreshArea.ALL);
        this.serverBehaviour = serverBehaviour;
        this.setText(Messages.DeleteServicesAction_TEXT_DELETE);
        this.setImageDescriptor(CloudFoundryImages.REMOVE);
        this.servicesHandler = new ServicesHandler(selection);
    }

    @Override
    public String getJobName() {
        return "Deleting services";
    }

    @Override
    public ICloudFoundryOperation getOperation(IProgressMonitor monitor) throws CoreException {
        return this.serverBehaviour.operations().deleteServices(this.servicesHandler.getServiceNames());
    }

    @Override
    public void run() {
        boolean confirm = MessageDialog.openConfirm((Shell)this.getEditorPage().getSite().getShell(), (String)Messages.DeleteServicesAction_TEXT_DELETE_SERVICE, (String)NLS.bind((String)Messages.DeleteServicesAction_TEXT_DELETE_CONFIRMATION, (Object)this.servicesHandler.toString()));
        if (confirm) {
            super.run();
        }
    }
}

