/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.SelectionProviderAction;

public class EnableDisableAutoBuildAction
extends SelectionProviderAction {
    protected CodewindEclipseApplication app;

    public EnableDisableAutoBuildAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.DisableAutoBuildLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            if (this.app.isAvailable()) {
                if (this.app.isAutoBuild()) {
                    this.setText(Messages.DisableAutoBuildLabel);
                } else {
                    this.setText(Messages.EnableAutoBuildLabel);
                }
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"EnableDisableAutoBuildAction ran but no application was selected");
            return;
        }
        EnableDisableAutoBuildAction.enableDisableAutoBuild((CodewindApplication)this.app, !this.app.isAutoBuild());
    }

    public static void enableDisableAutoBuild(final CodewindApplication app, final boolean enable) {
        Job job = new Job(NLS.bind((String)Messages.EnableDisableAutoBuildJob, (Object)app.name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String actionKey = enable ? "enableautobuild" : "disableautobuild";
                    app.connection.requestProjectBuild(app, actionKey);
                    app.setAutoBuild(enable);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred changing auto build setting for: " + app.name + ", with id: " + app.projectID), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ErrorOnEnableDisableAutoBuild, (Object)app.name), (Throwable)e);
                }
            }
        };
        job.schedule();
    }
}

