/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { FWAuthToken } from "./FWAuthToken";
import { IAuthTokenProvider } from "./IAuthTokenProvider";
/**
 * AuthTokenWrapper is the conduit through the internal filewatcher codebase
 * requests secure authentication tokens from the IDE. In cases where the
 * authTokenProvider is null (eg is secure auth is not required), the methods of
 * this class are no-ops.
 *
 * This class was created as part of issue codewind/1309.
 */
export declare class AuthTokenWrapper {
    static readonly KEEP_LAST_X_STALE_KEYS = 10;
    /**
     * Contains an ordered (descending by creation time) list of invalids keys, with
     * at most KEEP_LAST_X_STALE_KEYS keys.
     */
    private _recentInvalidKeysQueue;
    /**
     * Contains invalid keys; used as a fast path to determine if a given key is
     * already invalid. The should be at most KEEP_LAST_X_STALE_KEYS here.
     */
    private _invalidKeysSet;
    private readonly _authTokenProvider;
    constructor(authTokenProvider: IAuthTokenProvider);
    getLatestToken(): FWAuthToken;
    /** Inform the IDE when a token is rejected. */
    informBadToken(token: FWAuthToken): void;
    /**
     * Return a representation of the token that is at most 32 characters long, so
     * as not to overwhelm the log file.
     */
    private digest;
}
