/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { ProjectToWatch } from "./ProjectToWatch";
/**
 * This class is responsible for taking the filename/path filters for a project
 * on the watched projects list, and applying those filters against a given path
 * string (returning true if a filter should be ignored).
 */
export declare class PathFilter {
    private readonly _filenameExcludePatterns;
    private readonly _pathExcludePatterns;
    constructor(ptw: ProjectToWatch);
    /**
     * File parameter should be relative path from project root, rather than an
     * absolute path.
     */
    isFilteredOutByFilename(pathParam: string): boolean;
    /**
     * File parameter should be relative path from project root, rather than an
     * absolute path.
     */
    isFilteredOutByPath(pathParam: string): boolean;
}
