/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.List;
import java.util.function.Function;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.petrinet.PythonHelper;

class Guard {
    private Expression expression = null;
    private boolean inverse = false;
    private PRepeatGuardType repeatGuardType = null;
    private Long repeatGuardValue = null;

    Guard(Expression expression) {
        this(expression, false);
    }

    Guard(Expression expression, boolean inverse) {
        assert (expression != null);
        this.expression = expression;
        this.inverse = inverse;
    }

    Guard(PRepeatGuardType repeatGuardType, Long repeatGuardValue) {
        this.repeatGuardType = repeatGuardType;
        this.repeatGuardValue = repeatGuardValue;
    }

    String toPython(Function<String, String> variablePrefix, List<String> parameters) {
        if (this.expression != null) {
            String expr = this.expression.eContainer() instanceof NonTriggeredTransition ? PythonHelper.expression(this.expression, variable -> "") : PythonHelper.expression(this.expression, variablePrefix);
            if (this.inverse) {
                expr = String.format("not (%s)", expr);
            }
            return expr;
        }
        String operation = this.repeatGuardType == PRepeatGuardType.MAX ? "<" : ">=";
        return String.format("gl.r %s %d", operation, this.repeatGuardValue);
    }

    static enum PRepeatGuardType {
        MIN,
        MAX;

    }
}

