/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.Messages;

public class AttachTab
extends AbstractLaunchConfigurationTab {
    private Text addressText;
    private Spinner portSpinner;

    public void createControl(Composite parent) {
        Composite resComposite = new Composite(parent, 0);
        resComposite.setLayout((Layout)new GridLayout(2, false));
        new Label(resComposite, 0).setText(Messages.AttachTab_address);
        this.addressText = new Text(resComposite, 2048);
        this.addressText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.addressText.addModifyListener(event -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label(resComposite, 0).setText(Messages.AttachTab_port);
        this.portSpinner = new Spinner(resComposite, 2048);
        this.portSpinner.setMinimum(0);
        this.portSpinner.setMaximum(65535);
        this.portSpinner.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        this.setControl((Control)resComposite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("address", "localhost");
        configuration.setAttribute("port", 9229);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.addressText.setText(configuration.getAttribute("address", ""));
            this.portSpinner.setSelection(configuration.getAttribute("port", -1));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("address", this.addressText.getText());
        configuration.setAttribute("port", this.portSpinner.getSelection());
    }

    public String getName() {
        return Messages.AttachTab_title;
    }
}

