import { MappedPosition } from 'source-map';
import * as utils from '../utils';
import { IPathMapping } from '../debugAdapterInterfaces';
export declare type MappedPosition = MappedPosition;
/**
 * A pair of the original path in the sourcemap, and the full absolute path as inferred
 */
export interface ISourcePathDetails {
    originalPath: string;
    inferredPath: string;
    startPosition: MappedPosition;
}
export declare class SourceMap {
    private _generatedPath;
    private _sources;
    private _smc;
    private _authoredPathCaseMap;
    private _allSourcePathDetails;
    private _originalSources;
    private _originalSourceRoot;
    /**
     * Returns list of ISourcePathDetails for all sources in this sourcemap, sorted by their
     * positions within the sourcemap.
     */
    readonly allSourcePathDetails: ISourcePathDetails[];
    /**
     * generatedPath: an absolute local path or a URL
     * json: sourcemap contents as string
     */
    constructor(generatedPath: string, json: string, pathMapping?: IPathMapping, sourceMapPathOverrides?: utils.IStringDictionary<string>, isVSClient?: boolean);
    readonly authoredSources: string[];
    generatedPath(): string;
    doesOriginateFrom(absPath: string): boolean;
    authoredPositionFor(line: number, column: number): MappedPosition;
    generatedPositionFor(source: string, line: number, column: number): MappedPosition;
    sourceContentFor(authoredSourcePath: string): string;
}
