"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_1 = require("lodash");
// The below is based on the CSS Modules implementation found here:
// https://github.com/webpack-contrib/css-loader/blob/master/lib/compile-exports.js
var dashesCamelCase = function (className) {
    return className.replace(/-+(\w)/g, function (match, firstLetter) {
        return firstLetter.toUpperCase();
    });
};
exports.transformClasses = function (camelCaseOption) { return function (className) {
    var entries = [];
    switch (camelCaseOption) {
        case true: {
            entries.push(className);
            var targetClassName = lodash_1.camelCase(className);
            if (targetClassName !== className) {
                entries.push(targetClassName);
            }
            break;
        }
        case 'dashes': {
            entries.push(className);
            var targetClassName = dashesCamelCase(className);
            if (targetClassName !== className) {
                entries.push(targetClassName);
            }
            break;
        }
        case 'only':
            entries.push(lodash_1.camelCase(className));
            break;
        case 'dashesOnly':
            entries.push(dashesCamelCase(className));
            break;
        default:
            entries.push(className);
            break;
    }
    return entries;
}; };
