/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.util;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.sqltools.common.ui.internal.Activator;
import org.eclipse.datatools.sqltools.common.ui.util.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageDescriptorRegistry {
    private HashMap fRegistry = new HashMap(10);
    private Display fDisplay;

    public ImageDescriptorRegistry() {
        this(Activator.getDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        this.fDisplay = display;
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        Assert.isTrue((this.fDisplay == Activator.getDisplay() ? 1 : 0) != 0, (String)Messages.ImageDescriptorRegistry_Allocating_image_for_wrong_display_1);
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.fRegistry.values()) {
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                ImageDescriptorRegistry.this.fDisplay.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageDescriptorRegistry.this.dispose();
                    }
                });
            }
        });
    }
}

