/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.binary.qualified;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.Relations;
import org.eclipse.emf.diffmerge.structures.binary.qualified.HashQBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.qualified.IRangedQBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;

public class HashInvertibleQBinaryRelation<T, U, Q>
extends HashQBinaryRelation<T, U, Q>
implements IRangedQBinaryRelation.InvertibleEditable<T, U, Q> {
    private final IRangedQBinaryRelation.Editable<U, T, Q> _inverser = this.newInverser();

    public HashInvertibleQBinaryRelation() {
        this((IEqualityTester)null);
    }

    public HashInvertibleQBinaryRelation(IEqualityTester tester_p) {
        super(tester_p);
    }

    @Override
    public boolean add(T source_p, U target_p) {
        boolean result = super.add(source_p, target_p);
        if (result) {
            this.getInverser().add(target_p, source_p);
        }
        return result;
    }

    @Override
    public boolean add(T source_p, U target_p, Q qualifier_p) {
        boolean result = super.add(source_p, target_p, qualifier_p);
        if (result) {
            this.getInverser().add(target_p, source_p, qualifier_p);
        }
        return result;
    }

    @Override
    public boolean addAll(T source_p, Collection<? extends U> targets_p) {
        boolean result = super.addAll(source_p, targets_p);
        if (result) {
            IRangedQBinaryRelation.Editable<T, U, Q> inverser = this.getInverser();
            for (U target : targets_p) {
                inverser.add(target, source_p);
            }
        }
        return result;
    }

    @Override
    public boolean addAll(T source_p, Collection<? extends U> targets_p, Q qualifier_p) {
        boolean result = super.addAll(source_p, targets_p, qualifier_p);
        if (result) {
            IRangedQBinaryRelation.Editable<T, U, Q> inverser = this.getInverser();
            for (U target : targets_p) {
                inverser.add(target, source_p, qualifier_p);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.getInverser().clear();
    }

    @Override
    public Collection<T> getInverse(U element_p) {
        return this.getInverser().get(element_p);
    }

    @Override
    public Collection<T> getInverse(U element_p, Q qualifier_p) {
        return this.getInverser().get(element_p, qualifier_p);
    }

    @Override
    public Collection<Q> getInverseQualifiers(U element_p) {
        return this.getInverser().getQualifiers(element_p);
    }

    protected IRangedQBinaryRelation.Editable<U, T, Q> getInverser() {
        return this._inverser;
    }

    @Override
    public Map<Q, Collection<T>> getInverseWithDetails(U element_p) {
        return this.getInverser().getWithDetails(element_p);
    }

    @Override
    public Collection<U> getTargets() {
        return this.getInverser().getSources();
    }

    @Override
    public IPropertyValue<Boolean> isInjective() {
        boolean result = Relations.rangedIsInjective(this);
        return PropertyValue.valueOf(result);
    }

    protected IRangedQBinaryRelation.Editable<U, T, Q> newInverser() {
        return new HashQBinaryRelation<U, T, Q>(this.getEqualityTester()){

            @Override
            public Q defaultQualifier() {
                return HashInvertibleQBinaryRelation.this.defaultQualifier();
            }
        };
    }

    @Override
    public boolean remove(T source_p, U target_p) {
        boolean result = super.remove(source_p, target_p);
        if (result) {
            this.getInverser().remove(target_p, source_p);
        }
        return result;
    }

    @Override
    public boolean remove(T source_p, U target_p, Q qualifier_p) {
        boolean result = super.remove(source_p, target_p, qualifier_p);
        if (result) {
            this.getInverser().remove(target_p, source_p, qualifier_p);
        }
        return result;
    }

    @Override
    public boolean removeQualifier(Q qualifier_p) {
        boolean result = super.removeQualifier(qualifier_p);
        if (result) {
            this.getInverser().removeQualifier(qualifier_p);
        }
        return result;
    }

    @Override
    public boolean removeSource(T source_p) {
        FArrayList targets = new FArrayList(this.get(source_p), this.getEqualityTester());
        boolean result = super.removeSource(source_p);
        if (result) {
            IRangedQBinaryRelation.Editable inverser = this.getInverser();
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                Object target = iterator.next();
                inverser.remove(target, source_p);
            }
        }
        return result;
    }

    @Override
    public boolean removeTarget(U target_p) {
        FArrayList<T> sources = new FArrayList<T>(this.getInverse(target_p), this.getEqualityTester());
        boolean result = this.getInverser().removeSource(target_p);
        if (result) {
            Iterator iterator = sources.iterator();
            while (iterator.hasNext()) {
                Object source = iterator.next();
                this.remove(source, target_p);
            }
        }
        return result;
    }
}

