/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.interactive;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridge;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.incremental.EMFIncrementalBridge;
import org.eclipse.emf.diffmerge.bridge.interactive.InteractiveBridgePlugin;
import org.eclipse.emf.diffmerge.bridge.interactive.Messages;
import org.eclipse.emf.diffmerge.bridge.interactive.UpdateDialog;
import org.eclipse.emf.diffmerge.bridge.interactive.editor.BridgeCompareEditorInput;
import org.eclipse.emf.diffmerge.bridge.interactive.editor.BridgeComparisonMethod;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergeSelector;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;

public class EMFInteractiveBridge<SD, TD extends IEditableModelScope>
extends EMFIncrementalBridge<SD, TD> {
    public static final String STATUS_SWITCH_TO_EDITOR = "editorSwitch";

    public EMFInteractiveBridge(IBridge<SD, TD> bridge_p, IDiffPolicy<EObject> diffPolicy_p, IMergePolicy<EObject> mergePolicy_p, IMergeSelector<EObject> merger_p) {
        super(bridge_p, diffPolicy_p, mergePolicy_p, merger_p);
    }

    protected EMFDiffNode createDiffNode(EComparison comparison_p, EditingDomain domain_p) {
        EMFDiffNode diffNode = new EMFDiffNode((GComparison)comparison_p, domain_p, true, false);
        diffNode.setReferenceRole(TARGET_DATA_ROLE);
        diffNode.setDrivingRole(TARGET_DATA_ROLE);
        diffNode.setLeftRole(TARGET_DATA_ROLE.opposite());
        return diffNode;
    }

    protected UpdateDialog createMergeDialog(EMFDiffNode diffNode_p) {
        return new UpdateDialog(Display.getDefault().getActiveShell(), this.getTitle(), diffNode_p);
    }

    protected String getTitle() {
        return Messages.InteractiveEMFBridge_DefaultDialogTitle;
    }

    protected boolean isAlwaysInteractive() {
        return true;
    }

    protected IStatus handleInteractiveMerge(IIncrementalBridgeExecution execution_p, IProgressMonitor monitor_p) {
        IStatus result = Status.CANCEL_STATUS;
        EditingDomain domain = null;
        Object mergeData = execution_p.getInteractiveMergeData();
        if (mergeData instanceof EComparison) {
            EComparison comparison = (EComparison)mergeData;
            IEditableTreeDataScope targetScope = comparison.getTargetScope();
            if (targetScope.iterator().hasNext()) {
                domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)targetScope.iterator().next()));
            }
            final EMFDiffNode diffNode = this.createDiffNode(comparison, domain);
            final int[] returnCodeWrapper = new int[1];
            final IStructuredSelection[] selectionWrapper = new IStructuredSelection[1];
            Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    UpdateDialog dialog = EMFInteractiveBridge.this.createMergeDialog(diffNode);
                    returnCodeWrapper[0] = dialog.open();
                    selectionWrapper[0] = dialog.getSelection();
                }
            });
            switch (returnCodeWrapper[0]) {
                case 0: {
                    result = Status.OK_STATUS;
                    break;
                }
                case 2: {
                    this.openInEditor(execution_p, diffNode, selectionWrapper[0]);
                    result = new Status(1, InteractiveBridgePlugin.getDefault().getPluginId(), STATUS_SWITCH_TO_EDITOR);
                    break;
                }
                default: {
                    result = Status.CANCEL_STATUS;
                }
            }
        }
        return result;
    }

    protected void openInEditor(IIncrementalBridgeExecution execution_p, EMFDiffNode diffNode_p, IStructuredSelection initialSelection_p) {
        BridgeComparisonMethod method = new BridgeComparisonMethod(diffNode_p);
        BridgeCompareEditorInput editorInput = new BridgeCompareEditorInput(method, execution_p, initialSelection_p);
        CompareUI.openCompareEditor((CompareEditorInput)editorInput, (boolean)true);
    }
}

