/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.util.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolFunction;
import org.eclipse.emf.diffmerge.bridge.util.structures.IField;
import org.eclipse.emf.diffmerge.bridge.util.structures.Struct;

public class EnumStruct<E extends Enum<E>>
extends Struct {
    public EnumStruct(List<? extends EnumField<E, ?>> fields_p) {
        super(fields_p);
    }

    public EnumStruct(Class<E> enumeration_p) {
        this(EnumStruct.generateFields(enumeration_p));
    }

    protected static <E extends Enum<E>> List<EnumField<E, ?>> generateFields(Class<E> enumeration_p) {
        Enum[] literals = (Enum[])enumeration_p.getEnumConstants();
        ArrayList result = new ArrayList(literals.length);
        Enum[] enumArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            Enum literal = enumArray[n2];
            EnumField field = new EnumField(literal);
            result.add(field);
            ++n2;
        }
        return result;
    }

    public <U> U get(E literal_p) {
        U result = null;
        EnumField<E, ?> field = this.getField(literal_p);
        if (field != null) {
            result = this.get((E)field);
        }
        return result;
    }

    public EnumField<E, ?> getField(E literal_p) {
        for (EnumField<E, ?> field : this.getFields()) {
            if (field.getLiteral() != literal_p) continue;
            return field;
        }
        return null;
    }

    public Set<EnumField<E, ?>> getFields() {
        return super.getFields();
    }

    public void set(E literal_p, Object value_p) {
        EnumField<E, ?> field = this.getField(literal_p);
        if (field == null) {
            throw new IllegalArgumentException("Field is not present for literal: " + ((Enum)literal_p).name());
        }
        this.set((E)field, value_p);
    }

    public static class EnumField<E extends Enum<E>, T>
    implements IField<T>,
    Comparable<EnumField<E, ?>> {
        private final E _literal;

        public EnumField(E literal_p) {
            this._literal = literal_p;
        }

        @Override
        public int compareTo(EnumField<E, ?> o_p) {
            return ((Enum)this.getLiteral()).compareTo(o_p.getLiteral());
        }

        public boolean equals(Object object_p) {
            boolean result = false;
            if (object_p instanceof EnumField) {
                EnumField peer = (EnumField)object_p;
                result = ((Enum)this.getLiteral()).equals(peer.getLiteral());
            }
            return result;
        }

        public E getLiteral() {
            return this._literal;
        }

        @Override
        public String getSymbol(ISymbolFunction function_p) {
            return ((Enum)this._literal).name();
        }

        public int hashCode() {
            return ((Enum)this.getLiteral()).hashCode();
        }
    }
}

