/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.sirius;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.impl.helpers.ComparisonRootContainerHelper;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.image.RichTextAttributeRegistry;
import org.eclipse.sirius.diagram.DiagramPackage;

public class SiriusImageHelper {
    private HashMap<EObject, String> _mainProjectNames = new HashMap();
    private ComparisonRootContainerHelper comparisonRootContainerHelper;

    public SiriusImageHelper() {
    }

    public SiriusImageHelper(IComparison comparison) {
        this.comparisonRootContainerHelper = new ComparisonRootContainerHelper(comparison);
    }

    public List<Object> adaptGetValue(EObject source_p, EAttribute attribute_p, List<Object> objects_p) {
        List<Object> objects = objects_p;
        if (RichTextAttributeRegistry.INSTANCE.getEAttributes().contains(attribute_p)) {
            objects = objects.stream().filter(String.class::isInstance).map(e -> this.replaceRichtextToRelative(source_p, (String)e)).collect(Collectors.toList());
        } else if (attribute_p == DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH) {
            objects = objects.stream().filter(String.class::isInstance).map(e -> this.replaceWorkspaceImageToRelative(source_p, (String)e)).collect(Collectors.toList());
        }
        return objects;
    }

    public Object adaptAddValue(EObject source_p, EAttribute attribute_p, Object value_p) {
        if (value_p instanceof String) {
            if (RichTextAttributeRegistry.INSTANCE.getEAttributes().contains(attribute_p)) {
                return this.replaceRichtextToHardcodedProject(source_p, (String)value_p);
            }
            if (attribute_p == DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH) {
                return this.replaceWorkspaceImageToHardcodedProject(source_p, (String)value_p);
            }
        }
        return value_p;
    }

    public Object adaptRemoveValue(EObject source_p, EAttribute attribute_p, Object value_p) {
        if (value_p instanceof String) {
            if (RichTextAttributeRegistry.INSTANCE.getEAttributes().contains(attribute_p)) {
                return this.replaceRichtextToHardcodedProject(source_p, (String)value_p);
            }
            if (attribute_p == DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH) {
                return this.replaceWorkspaceImageToHardcodedProject(source_p, (String)value_p);
            }
        }
        return value_p;
    }

    protected String replaceRichtextToRelative(EObject source_p, String value_p) {
        String projectName = this.getMainProjectName(source_p);
        if (projectName == null) {
            return value_p;
        }
        if (value_p.contains("src=\"cdo:/")) {
            projectName = URI.encodeFragment((String)projectName, (boolean)true);
        }
        return value_p.replaceAll("src=\"(cdo:/)?" + projectName + "/", "src=\"$1./");
    }

    protected String replaceRichtextToHardcodedProject(EObject source_p, String value_p) {
        String projectName = this.getMainProjectName(source_p);
        if (projectName == null) {
            return value_p;
        }
        if (value_p.contains("src=\"cdo:/")) {
            projectName = URI.encodeFragment((String)projectName, (boolean)true);
        }
        return value_p.replaceAll("src=\"(cdo:/)?\\./", "src=\"$1" + projectName + "/");
    }

    protected String replaceWorkspaceImageToRelative(EObject source_p, String value_p) {
        String projectName = this.getMainProjectName(source_p);
        if (projectName == null) {
            return value_p;
        }
        if (value_p.startsWith("cdo:/")) {
            projectName = URI.encodeFragment((String)projectName, (boolean)true);
        }
        return value_p.replaceAll("^(cdo:/)?" + projectName + "/", "$1./");
    }

    protected String replaceWorkspaceImageToHardcodedProject(EObject source_p, String value_p) {
        String projectName = this.getMainProjectName(source_p);
        if (projectName == null) {
            return value_p;
        }
        if (value_p.startsWith("cdo:/")) {
            projectName = URI.encodeFragment((String)projectName, (boolean)true);
        }
        return value_p.replaceAll("^(cdo:/)?\\./", "$1" + projectName + "/");
    }

    protected String getProjectName(EObject source_p) {
        Resource resource;
        EObject root = EcoreUtil.getRootContainer((EObject)source_p, (boolean)true);
        if (root != null && (resource = root.eResource()) != null) {
            ResourceSet set = resource.getResourceSet();
            return this.getProjectFromUri(resource.getURI(), set != null ? set.getURIConverter() : null);
        }
        return null;
    }

    protected String getProjectFromUri(URI uri_p, URIConverter converter) {
        if (uri_p.isPlatform()) {
            return URI.decode((String)uri_p.segment(1));
        }
        if (uri_p.segmentCount() == 1) {
            return URI.decode((String)uri_p.trimFileExtension().segment(uri_p.segmentCount() - 1));
        }
        if (converter != null) {
            URI uri = uri_p;
            while (uri.segmentCount() > 1) {
                URI project = (uri = uri.trimSegments(1)).appendSegment(".project");
                if (!converter.exists(project, null)) continue;
                return this.getNameFromDotProject(project, converter);
            }
        }
        return URI.decode((String)uri_p.segment(0));
    }

    protected String getNameFromDotProject(URI projectUri, URIConverter converter) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = converter.createInputStream(projectUri);){
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription(stream);
                return description.getName();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return URI.decode((String)projectUri.segment(projectUri.segmentCount() - 2));
        }
    }

    protected String getMainProjectName(EObject source_p) {
        EObject root;
        if (this.comparisonRootContainerHelper == null) {
            root = EcoreUtil.getRootContainer((EObject)source_p);
        } else {
            root = this.comparisonRootContainerHelper.getRootFromScope(source_p, Role.TARGET);
            if (root == source_p) {
                root = this.comparisonRootContainerHelper.getRootFromScope(root, Role.REFERENCE);
            }
        }
        if (!this._mainProjectNames.containsKey(root)) {
            String string = this.getProjectName(root);
            this._mainProjectNames.put(root, string);
        }
        return this._mainProjectNames.get(root);
    }
}

