/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.HeaderViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class EnhancedComparisonSideViewer
extends HeaderViewer<ComparisonSideViewer> {
    protected final boolean _isLeftSide;
    protected ComparisonSideViewer sideViewer;

    public EnhancedComparisonSideViewer(Composite parent_p, boolean isLeftSide_p) {
        this._isLeftSide = isLeftSide_p;
        this.createControls(parent_p);
    }

    @Override
    protected ComparisonSideViewer createInnerViewer(Composite parent_p) {
        this.sideViewer = new ComparisonSideViewer(parent_p, this._isLeftSide);
        return this.sideViewer;
    }

    protected void doRefresh() {
        Label imageLabel;
        EMFDiffNode input = this.getInput();
        ITreeDataScope<?> scope = ((ComparisonSideViewer)this.getInnerViewer()).getSideScope();
        Label textLabel = this.getTextLabel();
        if (textLabel != null) {
            this.updateHeaderText(textLabel, input, scope);
        }
        if ((imageLabel = this.getImageLabel()) != null) {
            this.updateHeaderImage(imageLabel, input, scope);
        }
    }

    protected ILabelProvider getHeaderLabelProvider() {
        IBaseLabelProvider baseLP;
        DiffMergeLabelProvider result = null;
        if (this.getInnerViewer() != null && (baseLP = ((ComparisonSideViewer)this.getInnerViewer()).getLabelProvider()) instanceof ILabelProvider) {
            result = (ILabelProvider)baseLP;
        }
        if (result == null) {
            result = DiffMergeLabelProvider.getInstance();
        }
        return result;
    }

    @Override
    public EMFDiffNode getInput() {
        return (EMFDiffNode)super.getInput();
    }

    public ITreeSelection getSelection() {
        return ((ComparisonSideViewer)this.getInnerViewer()).getSelection();
    }

    @Override
    protected void inputChanged(Object input_p, Object oldInput_p) {
        super.inputChanged(input_p, oldInput_p);
        this.doRefresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.doRefresh();
    }

    protected void updateHeaderImage(Label headerImageWidget_p, EMFDiffNode input_p, ITreeDataScope<?> scope_p) {
        Image image = this.getHeaderLabelProvider().getImage(scope_p);
        if (image != headerImageWidget_p.getImage()) {
            headerImageWidget_p.setImage(image);
            Control mainControl = this.getControl();
            if (mainControl instanceof Composite) {
                ((Composite)mainControl).layout();
            }
        }
    }

    protected void updateHeaderText(Label headerTextWidget_p, EMFDiffNode input_p, ITreeDataScope<?> scope_p) {
        ILabelProvider lp = this.getHeaderLabelProvider();
        if (lp instanceof IColorProvider) {
            Color newColor = ((IColorProvider)lp).getForeground(scope_p);
            headerTextWidget_p.setForeground(newColor);
        }
        String label = lp.getText(scope_p);
        headerTextWidget_p.setText(label);
        headerTextWidget_p.setToolTipText(label);
    }

    protected void setDirected(boolean directed) {
        this.sideViewer.setDirected(directed);
    }
}

