/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.operations.AbstractModelOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.factories.IPatternOperationFactory;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractDisplayOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractGraphicalWrappingOperation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphicalWrappingInstanceOperation<F>
extends AbstractGraphicalWrappingOperation<F, F> {
    private final Collection<IPatternInstance> _instances = new FArrayList();
    private final RefreshRequestKind _refreshRequest;
    private final Collection<Object> _createdDiagramElements;

    public AbstractGraphicalWrappingInstanceOperation(IModelOperation<? extends F> operation_p, Object diagram_p, RefreshRequestKind refreshRequest_p) {
        this(operation_p, null, diagram_p, refreshRequest_p);
    }

    public AbstractGraphicalWrappingInstanceOperation(IModelOperation<? extends F> operation_p, IPatternInstance instance_p, Object diagram_p, RefreshRequestKind refreshRequest_p) {
        super(operation_p, diagram_p, diagram_p != null ? diagram_p : instance_p, diagram_p != null ? diagram_p : instance_p);
        if (instance_p != null) {
            this._instances.add(instance_p);
        }
        this._refreshRequest = refreshRequest_p;
        this._createdDiagramElements = new FOrderedSet();
    }

    public IPatternInstance getInstance() {
        return this._instances.isEmpty() ? null : this._instances.iterator().next();
    }

    public Collection<Object> getNewDiagramElements() {
        return Collections.unmodifiableCollection(this._createdDiagramElements);
    }

    protected F run() {
        Object result = null;
        if (this.getWrappedOperation() != null) {
            ISemanticRuleProvider semanticRuleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(this.getTargetContext());
            semanticRuleProvider.reset();
            if (this.getWrappedOperation() instanceof AbstractModelOperation) {
                ((AbstractModelOperation)this.getWrappedOperation()).setModelEnvironment(this.getModelEnvironment());
            }
            result = this.getWrappedOperation().run((IProgressMonitor)this.getMonitor());
            semanticRuleProvider.reset();
        }
        if (this._instances.isEmpty()) {
            if (result instanceof IPatternInstance) {
                this._instances.add((IPatternInstance)result);
            } else if (result instanceof Collection) {
                for (Object o : (Collection)result) {
                    if (!(o instanceof IPatternInstance)) continue;
                    this._instances.add((IPatternInstance)o);
                }
            }
        }
        if ((result != null || this.getWrappedOperation() == null) && this.getDiagram() != null) {
            switch (this._refreshRequest) {
                case DIAGRAM: {
                    this.refreshDiagram();
                    break;
                }
                case INSTANCE: {
                    IPatternOperationFactory factory = PatternCoreDiagramPlugin.getDefault().getOperationFactory();
                    if (factory == null) break;
                    for (IPatternInstance instance : this._instances) {
                        List roots = TemplatePatternsUtil.getApplicationRoots((IPatternApplication)instance);
                        AbstractDisplayOperation displayOperation = factory.instantiateDisplayOperation(roots, this.getDiagram(), true);
                        this._createdDiagramElements.addAll((Collection)this.call(displayOperation));
                    }
                    break;
                }
            }
        }
        return (F)result;
    }

    protected Collection<IPatternInstance> getInstances() {
        return this._instances;
    }

    protected RefreshRequestKind getRefreshRequestkind() {
        return this._refreshRequest;
    }

    protected Collection<Object> getCreatedDiagramElements() {
        return this._createdDiagramElements;
    }

    protected abstract void refreshDiagram();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RefreshRequestKind {
        NONE,
        DIAGRAM,
        INSTANCE;

    }
}

