/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.extensions.ISemanticMapping;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractDisplayOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.extensions.ISiriusSemanticMapping;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusLayersUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusUtil;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.diffmerge.util.structures.FHashMap;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.IContainerMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.ui.tools.api.layout.PinHelper;
import org.eclipse.sirius.viewpoint.DContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiriusDisplayOperation
extends AbstractDisplayOperation {
    private final PinHelper _pinHelper = new PinHelper();

    public SiriusDisplayOperation(Collection<? extends EObject> semanticElements_p, Object diagram_p, boolean refresh_p) {
        super(semanticElements_p, diagram_p, refresh_p);
    }

    protected Collection<Object> updateDiagram(Object objectDiagram_p) {
        if (objectDiagram_p instanceof DDiagram) {
            DDiagram diagram_p = (DDiagram)objectDiagram_p;
            FOrderedSet rootsAndContainers = new FOrderedSet();
            rootsAndContainers.addAll(this._semanticRoots);
            ISiriusSemanticMapping sMapping = null;
            ISemanticMapping mapping = PatternCoreDiagramPlugin.getDefault().getSemanticMapping();
            if (mapping instanceof ISiriusSemanticMapping) {
                sMapping = (ISiriusSemanticMapping)mapping;
            }
            for (EObject root : this._semanticRoots) {
                Collection candidates = sMapping.getSemanticCandidatesForGraphicalStorage(root, diagram_p);
                rootsAndContainers.addAll(candidates);
            }
            EMap<EObject, DSemanticDecorator> rootsToNodes = this.getExistingDecorators((Collection<? extends EObject>)rootsAndContainers, (DDiagram)this._diagram);
            LinkedList<DContainer> containers = new LinkedList<DContainer>(SiriusDisplayOperation.filter((Iterable)rootsToNodes.values(), DContainer.class));
            List remainingElements = ModelsUtil.getAllContents((Collection)this._semanticRoots, (boolean)false, null);
            remainingElements.removeAll(rootsToNodes.keySet());
            FOrderedSet remainingElementsCopy = new FOrderedSet((Collection)remainingElements);
            for (EObject remainingElement : remainingElementsCopy) {
                Collection<AbstractDNode> nodes = this.getNodesInDiagram(remainingElement, diagram_p);
                if (nodes.isEmpty()) continue;
                remainingElements.remove(remainingElement);
                for (AbstractDNode node : nodes) {
                    if (!(node instanceof DNodeContainer)) continue;
                    containers.add((DContainer)((DNodeContainer)node));
                }
            }
            FOrderedSet createdNodes = new FOrderedSet();
            this.showAllInContainers(containers, remainingElements, (Collection<Object>)createdNodes);
            if (!rootsToNodes.values().contains(this._diagram)) {
                this.showAllInContainer((DContainer)diagram_p, remainingElements, (Collection<Object>)createdNodes);
            }
            return Collections.unmodifiableCollection(createdNodes);
        }
        return Collections.emptyList();
    }

    protected void refreshDiagram() {
        SiriusUtil.refreshDiagram((DDiagram)this._diagram);
    }

    private void showAllInContainer(DContainer container_p, Collection<EObject> remainingElements_p, Collection<Object> createdNodes_p) {
        LinkedList<DContainer> containers = new LinkedList<DContainer>();
        containers.add(container_p);
        this.showAllInContainers(containers, remainingElements_p, createdNodes_p);
    }

    private void showAllInContainers(LinkedList<DContainer> containers_p, Collection<EObject> remainingElements_p, Collection<Object> createdNodes_p) {
        while (!containers_p.isEmpty() && !remainingElements_p.isEmpty()) {
            DContainer nodeContainer = containers_p.poll();
            Collection<AbstractDNode> allCreated = this.showInContainer(nodeContainer, remainingElements_p);
            createdNodes_p.addAll(allCreated);
            containers_p.addAll(SiriusDisplayOperation.filter(allCreated, DNodeContainer.class));
        }
    }

    private Collection<AbstractDNode> showInContainer(DContainer graphicalContainer_p, Collection<EObject> remainingElements_p) {
        FOrderedSet result = new FOrderedSet();
        UniqueEList<AbstractNodeMapping> innerMappings = SiriusUtil.getApplicableMappingsIn(graphicalContainer_p);
        UniqueEList<AbstractNodeMapping> reducedInnerMappings = SiriusUtil.reduceByImport(innerMappings);
        for (EObject currentElement : new FOrderedSet(remainingElements_p)) {
            AbstractDNode created = null;
            Iterator it = reducedInnerMappings.iterator();
            while (created == null && it.hasNext()) {
                AbstractNodeMapping mapping = (AbstractNodeMapping)it.next();
                created = this.showElement(mapping, currentElement, graphicalContainer_p);
            }
            if (created == null) continue;
            result.add(created);
            remainingElements_p.remove(currentElement);
        }
        return Collections.unmodifiableCollection(result);
    }

    private AbstractDNode showElement(AbstractNodeMapping mapping_p, EObject semanticTarget_p, DContainer graphicalContainer_p) {
        DNode result = null;
        DDiagram diagram = SiriusUtil.getDiagram((EObject)graphicalContainer_p);
        ISemanticMapping mapping = PatternCoreDiagramPlugin.getDefault().getSemanticMapping();
        EObject target = null;
        if (mapping instanceof ISiriusSemanticMapping) {
            target = ((ISiriusSemanticMapping)mapping).getSemanticStorage(graphicalContainer_p);
            try {
                if (((ISiriusSemanticMapping)mapping).conformsToMapping(semanticTarget_p, mapping_p, true, true, graphicalContainer_p)) {
                    if (mapping_p instanceof IContainerMappingExt) {
                        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticTarget_p);
                        ContainerMappingHelper cmh = new ContainerMappingHelper(interpreter);
                        result = cmh.createContainer((IContainerMappingExt)mapping_p, semanticTarget_p, target, diagram);
                    } else if (mapping_p instanceof NodeMapping) {
                        NodeMapping nm = (NodeMapping)mapping_p;
                        result = nm.createNode(semanticTarget_p, target, diagram);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result != null) {
            if (graphicalContainer_p instanceof DNodeContainer) {
                ((DNodeContainer)graphicalContainer_p).getOwnedDiagramElements().add(result);
            } else {
                diagram.getOwnedDiagramElements().add(result);
            }
            this._pinHelper.markAsPinned(result);
        }
        return result;
    }

    private EMap<EObject, DSemanticDecorator> getExistingDecorators(Collection<? extends EObject> semanticElements_p, DDiagram diagram_p) {
        DSemanticDecorator dSemanticDecorator;
        EObject diagramTarget;
        FHashMap result = new FHashMap();
        if (diagram_p instanceof DSemanticDecorator && (diagramTarget = (dSemanticDecorator = (DSemanticDecorator)diagram_p).getTarget()) != null && semanticElements_p.contains(diagramTarget)) {
            result.put((Object)diagramTarget, (Object)dSemanticDecorator);
        }
        for (EObject eObject : semanticElements_p) {
            Collection<AbstractDNode> nodes = this.getNodesInDiagram(eObject, diagram_p);
            if (nodes.isEmpty()) continue;
            result.put((Object)eObject, (Object)((DSemanticDecorator)nodes.iterator().next()));
        }
        return result;
    }

    private Collection<AbstractDNode> getNodesInDiagram(EObject element_p, DDiagram diagram_p) {
        FOrderedSet result = new FOrderedSet();
        List<DSemanticDecorator> decorators = SiriusLayersUtil.upSemanticToViewpoint(element_p);
        for (DSemanticDecorator decorator : decorators) {
            if (!(decorator instanceof AbstractDNode) || diagram_p != SiriusUtil.getDiagram((EObject)decorator)) continue;
            result.add((AbstractDNode)decorator);
        }
        return Collections.unmodifiableCollection(result);
    }
}

