/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoiceData;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MergeChoicesDialog
extends MessageDialog {
    private final MergeChoiceData _data;
    private final boolean _askAboutChildren;

    public MergeChoicesDialog(Shell parentShell_p, String title_p, MergeChoiceData data_p, boolean askAboutChildren_p) {
        super(parentShell_p, title_p, null, Messages.MergeChoicesDialog_Question, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this._data = data_p;
        this._askAboutChildren = askAboutChildren_p;
    }

    protected Control createCustomArea(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        GridLayout layout = new GridLayout(1, true);
        result.setLayout((Layout)layout);
        Button coverChildrenButton = new Button(result, 32);
        coverChildrenButton.setText(Messages.MergeChoicesDialog_IncludeChildren);
        coverChildrenButton.setSelection(this.getData().isCoverChildren());
        coverChildrenButton.setEnabled(this._askAboutChildren);
        coverChildrenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                MergeChoicesDialog.this.getData().setCoverChildren(!MergeChoicesDialog.this.getData().isCoverChildren());
            }
        });
        Button incrementalModeButton = new Button(result, 32);
        incrementalModeButton.setText(Messages.MergeChoicesDialog_IncrementalMode);
        incrementalModeButton.setSelection(this.getData().isIncrementalMode());
        incrementalModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                MergeChoicesDialog.this.getData().setIncrementalMode(!MergeChoicesDialog.this.getData().isIncrementalMode());
            }
        });
        Button showImpactButton = new Button(result, 32);
        showImpactButton.setText(Messages.MergeChoicesDialog_ShowImpact);
        showImpactButton.setSelection(this.getData().isShowImpact());
        showImpactButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                MergeChoicesDialog.this.getData().setShowImpact(!MergeChoicesDialog.this.getData().isShowImpact());
            }
        });
        return result;
    }

    protected MergeChoiceData getData() {
        return this._data;
    }

    public int open() {
        int result = super.open();
        this._data.setProceed(result == 0);
        return result;
    }
}

