/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWorkbenchSelectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbenchPart activePart = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            activePart = page.getActivePart();
            if (activePart != null) {
                ISelectionProvider provider;
                IWorkbenchPartSite site = activePart.getSite();
                if (site != null && (provider = site.getSelectionProvider()) != null) {
                    this.handleSelection(provider.getSelection(), activePart);
                }
            } else {
                ISelectionProvider provider;
                IViewSite site;
                IViewPart part;
                IWorkbenchPartReference ref = page.getActivePartReference();
                if (ref instanceof IViewReference && (part = ((IViewReference)ref).getView(true)) != null && (site = part.getViewSite()) != null && (provider = site.getSelectionProvider()) != null) {
                    this.handleSelection(provider.getSelection(), activePart);
                }
            }
        }
        return null;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }

    protected abstract Object handleSelection(ISelection var1, IWorkbenchPart var2);
}

