/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.UIComparison;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.UIComparisonImpl;
import org.eclipse.emf.diffmerge.ui.setup.ModelScopeTypedElement;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.CategoryManager;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorInput;

public class EMFDiffNode
extends DiffNode
implements IDisposable,
IEditingDomainProvider {
    private final ComparisonResourceManager _resourceManager = new ComparisonResourceManager();
    private final UIComparison _contents;
    private final EditingDomain _editingDomain;
    private IEditorInput _editorInput;
    private Role _drivingRole;
    private Role _leftRole;
    private Role _twoWayReferenceRole;
    private final CategoryManager _categoryManager;
    private boolean _useCustomIcons;
    private boolean _useCustomLabels;
    private boolean _isTargetEditable;
    private boolean _isReferenceEditable;
    private boolean _isTargetEditionPossible;
    private boolean _isReferenceEditionPossible;
    private boolean _isTargetModified;
    private boolean _isReferenceModified;
    private boolean _isHideDifferenceNumbers;
    private boolean _isShowMergeImpact;
    private boolean _isUndoRedoSupported;
    private boolean _isLogEvents;
    private boolean _defaultCoverChildren;
    private boolean _defaultIncrementalMode;
    private boolean _defaultShowMergeImpact;
    private final Map<EMFDiffMergeUIPlugin.DifferenceColorKind, Integer> _differenceColors;

    public EMFDiffNode(EComparison comparison_p) {
        this(comparison_p, null);
    }

    public EMFDiffNode(EComparison comparison_p, EditingDomain domain_p) {
        this(comparison_p, domain_p, true, true);
    }

    public EMFDiffNode(EComparison comparison_p, EditingDomain domain_p, boolean isLeftEditionPossible_p, boolean isRightEditionPossible_p) {
        super(3, (ITypedElement)(comparison_p.isThreeWay() ? new ModelScopeTypedElement(comparison_p.getScope(Role.ANCESTOR)) : null), (ITypedElement)new ModelScopeTypedElement(comparison_p.getScope(Role.TARGET)), (ITypedElement)new ModelScopeTypedElement(comparison_p.getScope(Role.REFERENCE)));
        this._contents = new UIComparisonImpl(comparison_p);
        this._editingDomain = domain_p;
        this._editorInput = null;
        this._drivingRole = this._leftRole = EMFDiffMergeUIPlugin.getDefault().getDefaultLeftRole();
        this._twoWayReferenceRole = null;
        this._categoryManager = new CategoryManager(this);
        this._differenceColors = new HashMap<EMFDiffMergeUIPlugin.DifferenceColorKind, Integer>();
        this.initializeDifferenceColors(this._differenceColors);
        this._useCustomIcons = true;
        this._useCustomLabels = false;
        this._isTargetEditionPossible = isLeftEditionPossible_p;
        this._isReferenceEditionPossible = isRightEditionPossible_p;
        this._isTargetEditable = true;
        this._isReferenceEditable = true;
        this._isTargetModified = false;
        this._isReferenceModified = false;
        this._isHideDifferenceNumbers = false;
        this._isShowMergeImpact = true;
        this._isUndoRedoSupported = this._editingDomain != null;
        this._isLogEvents = false;
        this._defaultShowMergeImpact = this._isShowMergeImpact;
        this._defaultCoverChildren = true;
        this._defaultIncrementalMode = false;
    }

    protected void initializeDifferenceColors(Map<EMFDiffMergeUIPlugin.DifferenceColorKind, Integer> differenceColorsMap_p) {
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.LEFT, 4);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.RIGHT, 9);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.BOTH, 12);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.NONE, 15);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.CONFLICT, 3);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.DEFAULT, 2);
    }

    public boolean isEditable(boolean left_p) {
        boolean result = this.isEditionPossible(left_p);
        if (result) {
            result = this.getRoleForSide(left_p) == Role.TARGET ? this._isTargetEditable : this._isReferenceEditable;
        }
        return result;
    }

    public boolean isEditionPossible(boolean left_p) {
        return this.getRoleForSide(left_p) == Role.TARGET ? this._isTargetEditionPossible : this._isReferenceEditionPossible;
    }

    public boolean isModified(boolean left_p) {
        return this.getRoleForSide(left_p) == Role.TARGET ? this._isTargetModified : this._isReferenceModified;
    }

    public boolean isShowMergeImpact() {
        return this._isShowMergeImpact;
    }

    public boolean isUndoRedoSupported() {
        return this._isUndoRedoSupported;
    }

    public boolean isLogEvents() {
        return this._isLogEvents;
    }

    public boolean isContainment(EStructuralFeature feature_p) {
        boolean result = false;
        if (feature_p instanceof EReference) {
            EReference reference = (EReference)feature_p;
            EComparison comparison = this.getActualComparison();
            if (comparison != null) {
                IFeaturedModelScope scope = comparison.getScope(this.getDrivingRole());
                result = scope.isContainment(reference);
            } else {
                result = reference.isContainment();
            }
        }
        return result;
    }

    public boolean isDefaultCoverChildren() {
        return this._defaultCoverChildren;
    }

    public boolean isDefaultIncrementalMode() {
        return this._defaultIncrementalMode;
    }

    public boolean isDefaultShowImpact() {
        return this._defaultShowMergeImpact;
    }

    public void dispose() {
        this._resourceManager.dispose();
        this._editorInput = null;
    }

    public EComparison getActualComparison() {
        return this.getUIComparison().getActualComparison();
    }

    public CategoryManager getCategoryManager() {
        return this._categoryManager;
    }

    protected EMatch getContainerOf(EMatch match_p) {
        EMatch result = null;
        EComparison comparison = this.getActualComparison();
        if (comparison != null) {
            Role drivingRole = this.getDrivingRole();
            Role containerSide = match_p.getUncoveredRole() == drivingRole ? drivingRole.opposite() : drivingRole;
            result = (EMatch)comparison.getContainerOf((IMatch)match_p, containerSide);
        }
        return result;
    }

    public Color getDifferenceColor(EMFDiffMergeUIPlugin.DifferenceColorKind colorKind_p) {
        int colorCode = 2;
        Integer colorCodeI = this._differenceColors.get((Object)colorKind_p);
        if (colorCodeI != null) {
            colorCode = colorCodeI;
        }
        return UIUtil.getColor(colorCode);
    }

    public Role getDrivingRole() {
        return this._drivingRole;
    }

    public EditingDomain getEditingDomain() {
        return this._editingDomain;
    }

    public Role getReferenceRole() {
        return this.isThreeWay() ? Role.ANCESTOR : this._twoWayReferenceRole;
    }

    public IEditorInput getEditorInput() {
        return this._editorInput;
    }

    public ComparisonResourceManager getResourceManager() {
        return this._resourceManager;
    }

    public Role getRoleForSide(boolean left_p) {
        return left_p ? this._leftRole : this._leftRole.opposite();
    }

    public UIComparison getUIComparison() {
        return this._contents;
    }

    public boolean hasChildren() {
        EComparison comparison = this.getActualComparison();
        return comparison != null ? comparison.hasRemainingDifferences() : false;
    }

    public boolean isEmpty() {
        return this.getCategoryManager().isEmpty();
    }

    public boolean isHideDifferenceNumbers() {
        return this._isHideDifferenceNumbers;
    }

    public boolean isThreeWay() {
        EComparison comparison = this.getActualComparison();
        return comparison != null ? comparison.isThreeWay() : false;
    }

    public void setDefaultCoverChildren(boolean coverChildren_p) {
        this._defaultCoverChildren = coverChildren_p;
    }

    public void setDefaultIncrementalMode(boolean isIncrementalMode_p) {
        this._defaultIncrementalMode = isIncrementalMode_p;
    }

    public void setDefaultShowImpact(boolean showImpact_p) {
        this._defaultShowMergeImpact = showImpact_p;
    }

    public void setDifferenceColor(EMFDiffMergeUIPlugin.DifferenceColorKind colorKind_p, int swtColor_p) {
        this._differenceColors.put(colorKind_p, new Integer(swtColor_p));
    }

    public void setDrivingRole(Role drivingRole_p) {
        if (Role.TARGET == drivingRole_p || Role.REFERENCE == drivingRole_p) {
            this._drivingRole = drivingRole_p;
        }
    }

    public void setEditable(boolean isEditable_p, boolean left_p) {
        if (this.isEditionPossible(left_p)) {
            if (this.getRoleForSide(left_p) == Role.TARGET) {
                this._isTargetEditable = isEditable_p;
            } else {
                this._isReferenceEditable = isEditable_p;
            }
        }
    }

    public void setEditionPossible(boolean possible_p, boolean left_p) {
        if (this.getRoleForSide(left_p) == Role.TARGET) {
            this._isTargetEditionPossible = possible_p;
        } else {
            this._isReferenceEditionPossible = possible_p;
        }
    }

    public void setEditorInput(IEditorInput editorInput_p) {
        this._editorInput = editorInput_p;
    }

    public void setHideDifferenceNumbers(boolean hideDifferenceNumbers_p) {
        this._isHideDifferenceNumbers = hideDifferenceNumbers_p;
    }

    public void setLeftRole(Role leftRole_p) {
        if (Role.TARGET == leftRole_p || Role.REFERENCE == leftRole_p) {
            this._leftRole = leftRole_p;
        }
    }

    public void setLogEvents(boolean logEvents_p) {
        this._isLogEvents = logEvents_p;
    }

    public void setModified(boolean isModified_p, boolean left_p) {
        if (this.getRoleForSide(left_p) == Role.TARGET) {
            this._isTargetModified = isModified_p;
        } else {
            this._isReferenceModified = isModified_p;
        }
    }

    public void setReferenceRole(Role role_p) {
        if (!this.isThreeWay()) {
            this._twoWayReferenceRole = role_p;
        }
    }

    public void setShowMergeImpact(boolean showMergeImpact_p) {
        this._isShowMergeImpact = showMergeImpact_p;
    }

    public void setUndoRedoSupported(boolean supportUndoRedo_p) {
        this._isUndoRedoSupported = this.getEditingDomain() != null && supportUndoRedo_p;
    }

    public void setUseCustomIcons(boolean useCustom_p) {
        this._useCustomIcons = useCustom_p;
    }

    public void setUseCustomLabels(boolean useCustom_p) {
        this._useCustomLabels = useCustom_p;
    }

    public boolean usesCustomIcons() {
        return this._useCustomIcons;
    }

    public boolean usesCustomLabels() {
        return this._useCustomLabels;
    }

    public void updateDifferenceNumbers() {
        this.getCategoryManager().update();
        this.fireChange();
    }
}

