/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.FeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.HeaderViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class EnhancedFeaturesViewer
extends HeaderViewer<FeaturesViewer> {
    public EnhancedFeaturesViewer(Composite parent_p) {
        this.createControls(parent_p);
    }

    @Override
    protected Label createImageLabel(Composite parent_p) {
        return null;
    }

    @Override
    protected FeaturesViewer createInnerViewer(Composite parent_p) {
        return new FeaturesViewer(parent_p);
    }

    @Override
    protected Label createTextLabel(Composite parent_p) {
        Label result = super.createTextLabel(parent_p);
        result.setFont(UIUtil.getBold(result.getFont()));
        result.setText(this.getDefaultText());
        return result;
    }

    protected String getDefaultText() {
        return Messages.ComparisonViewer_Details;
    }

    protected EObject getDrivingElement(FeaturesViewer.FeaturesInput input_p) {
        Role drivingRole;
        IMatch match = input_p.getMatch();
        EObject element = match.get(drivingRole = input_p.getContext().getDrivingRole());
        if (element == null) {
            element = match.get(drivingRole.opposite());
        }
        return element;
    }

    @Override
    public FeaturesViewer.FeaturesInput getInput() {
        return (FeaturesViewer.FeaturesInput)super.getInput();
    }

    @Override
    protected void inputChanged(Object input_p, Object oldInput_p) {
        Label textLabel = this.getTextLabel();
        if (textLabel != null && !textLabel.isDisposed()) {
            String newText;
            if (input_p instanceof FeaturesViewer.FeaturesInput) {
                FeaturesViewer.FeaturesInput input = (FeaturesViewer.FeaturesInput)input_p;
                EObject element = this.getDrivingElement(input);
                String formattedTypeText = UIUtil.getFormattedTypeText(element);
                newText = String.format(Messages.EnhancedFeaturesViewer_DetailsWithSelection, formattedTypeText);
            } else {
                newText = this.getDefaultText();
            }
            textLabel.setText(newText);
        }
        super.inputChanged(input_p, oldInput_p);
    }
}

