/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testng.container;

import java.util.ArrayList;
import java.util.Collections;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.testng.container.RemoveDependsOnTransformer;
import org.jboss.arquillian.testng.container.TestListener;
import org.testng.ITestNGListener;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGTestRunner
implements TestRunner {
    public TestResult execute(Class<?> testClass, String methodName) {
        TestListener resultListener = new TestListener();
        TestNG runner = new TestNG(false);
        runner.setVerbose(0);
        runner.addListener((ITestNGListener)resultListener);
        runner.addListener((ITestNGListener)new RemoveDependsOnTransformer());
        runner.setXmlSuites(Collections.singletonList(this.createSuite(testClass, methodName)));
        try {
            runner.run();
        }
        catch (Throwable ex) {
            return TestResult.failed((Throwable)ex);
        }
        return resultListener.getTestResult();
    }

    private XmlSuite createSuite(Class<?> className, String methodName) {
        XmlSuite suite = new XmlSuite();
        suite.setName("Arquillian");
        XmlTest test = new XmlTest(suite);
        test.setName("Arquillian - " + className);
        ArrayList<XmlClass> testClasses = new ArrayList<XmlClass>();
        XmlClass testClass = new XmlClass(className);
        testClass.getIncludedMethods().add(new XmlInclude(methodName));
        testClasses.add(testClass);
        test.setXmlClasses(testClasses);
        return suite;
    }
}

