/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.containerelement;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ContainerElementConstraintListTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ContainerElementConstraintListTest.webArchiveBuilder().withTestClass(ContainerElementConstraintListTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void field_constraint_provided_on_type_parameter_of_a_list_gets_validated() {
        TypeWithList1 l = new TypeWithList1();
        l.names = Arrays.asList("First", "", null);
        Set constraintViolations = this.getValidator().validate((Object)l, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<list element>", true, null, 1, List.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="d"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constraints_specified_on_list_and_on_type_parameter_of_list_get_validated() {
        TypeWithList2 l = new TypeWithList2();
        l.names = Arrays.asList("First", "", null);
        Set constraintViolations = this.getValidator().validate((Object)l, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<list element>", true, null, 1, List.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null));
        l = new TypeWithList2();
        l.names = new ArrayList<String>();
        constraintViolations = this.getValidator().validate((Object)l, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("names").withInvalidValue(l.names));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void getter_constraint_provided_on_type_parameter_of_a_list_gets_validated() {
        TypeWithList3 l = new TypeWithList3();
        l.strings = Arrays.asList("", "First", null);
        Set constraintViolations = this.getValidator().validate((Object)l, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("strings").containerElement("<list element>", true, null, 0, List.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("strings").containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("strings").containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void return_value_constraint_provided_on_type_parameter_of_a_list_gets_validated() throws Exception {
        Method method = TypeWithList4.class.getDeclaredMethod("returnStrings", new Class[0]);
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)new TypeWithList4(), method, Arrays.asList("First", "", null), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStrings").returnValue().containerElement("<list element>", true, null, 1, List.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStrings").returnValue().containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStrings").returnValue().containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void method_parameter_constraint_provided_as_type_parameter_of_a_list_gets_validated() throws Exception {
        Method method = TypeWithList5.class.getDeclaredMethod("setValues", List.class);
        Object[] values = new Object[]{Arrays.asList("", "First", null)};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)new TypeWithList5(), method, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("listParameter", 0).containerElement("<list element>", true, null, 0, List.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("listParameter", 0).containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("listParameter", 0).containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constructor_parameter_constraint_provided_on_type_parameter_of_a_list_gets_validated() throws Exception {
        Constructor constructor = TypeWithList6.class.getDeclaredConstructor(List.class);
        Object[] values = new Object[]{Arrays.asList("", "First", null)};
        Set constraintViolations = this.getValidator().forExecutables().validateConstructorParameters(constructor, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithList6.class).parameter("listParameter", 0).containerElement("<list element>", true, null, 0, List.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithList6.class).parameter("listParameter", 0).containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithList6.class).parameter("listParameter", 0).containerElement("<list element>", true, null, 2, List.class, 0)).withInvalidValue(null));
    }

    private static class TypeWithList1 {
        private List<@NotNull @NotBlank String> names;

        private TypeWithList1() {
        }
    }

    private static class TypeWithList2 {
        @Size(min=1)
        private @Size(min=1) List<@NotBlank String> names;

        private TypeWithList2() {
        }
    }

    private static class TypeWithList3 {
        private List<String> strings;

        private TypeWithList3() {
        }

        public List<@NotNull @NotBlank String> getStrings() {
            return this.strings;
        }
    }

    private static class TypeWithList4 {
        private List<String> strings;

        private TypeWithList4() {
        }

        public List<@NotNull @NotBlank String> returnStrings() {
            return this.strings;
        }
    }

    private static class TypeWithList5 {
        private TypeWithList5() {
        }

        public void setValues(List<@NotNull @NotBlank String> listParameter) {
        }
    }

    private static class TypeWithList6 {
        public TypeWithList6(List<@NotNull @NotBlank String> listParameter) {
        }
    }
}

