/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validatorfactory;

import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.ValidationException;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MyConstraint;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MyConstraintValidator;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MySecondConstraint;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MySecondConstraintValidator;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class DefaultConstraintValidatorFactoryTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)DefaultConstraintValidatorFactoryTest.webArchiveBuilder().withTestClass(DefaultConstraintValidatorFactoryTest.class)).withClass(MyConstraint.class)).withClass(MyConstraintValidator.class)).withClass(MySecondConstraint.class)).withClass(MySecondConstraintValidator.class)).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="c")
    public void testDefaultConstructorInValidatorCalled() {
        ConstraintValidatorFactory factory = TestUtil.getConfigurationUnderTest().getDefaultConstraintValidatorFactory();
        factory.getInstance(MyConstraintValidator.class);
        Assert.assertTrue((boolean)MyConstraintValidator.defaultConstructorCalled, (String)"The no-arg default constructor should have been called.");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="c")
    public void testRuntimeExceptionInValidatorCreationIsWrapped() {
        ConstraintValidatorFactory factory = TestUtil.getConfigurationUnderTest().getDefaultConstraintValidatorFactory();
        factory.getInstance(MySecondConstraintValidator.class);
    }
}

