/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.definition;

import jakarta.validation.Valid;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.valueextraction.ValueExtractor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.Container;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.ContainerElement;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.ContainerValueExtractorCompareInstance;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.ContainerValueExtractorCountCalls;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.CustomConstraint;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.IndexedValueContainerValueExtractor;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.IterableValueContainerValueExtractor;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.KeyedValueContainerValueExtractor;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.LocalMapKeyExtractor;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.LocalMapValueExtractor;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.NullNodeNameContainerValueExtractor;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.Order;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.RetailOrder;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.ValueContainerValueExtractor;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ValueExtractorDefinitionTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ValueExtractorDefinitionTest.webArchiveBuilder().withTestClass(ValueExtractorDefinitionTest.class)).withPackage(Container.class.getPackage())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="valueextractordefinition", id="a"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="a"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="c")})
    public void instanceAndValueReceiverPassedToExtractValues() {
        Container<Object> container = new Container<Object>(null);
        StringContainerHolder containerHolder = new StringContainerHolder(container);
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new ContainerValueExtractorCompareInstance(container)).buildValidatorFactory().getValidator();
        validator.validate((Object)containerHolder, new Class[0]);
        Assert.assertEquals((int)ContainerValueExtractorCompareInstance.callCounter, (int)1);
    }

    @Test
    @SpecAssertion(section="valueextractordefinition", id="b")
    public void valueExtractorNotInvokedIfContainerIsNull() {
        StringContainerHolder containerHolder = new StringContainerHolder(null);
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new ContainerValueExtractorCountCalls()).buildValidatorFactory().getValidator();
        validator.validate((Object)containerHolder, new Class[0]);
        Assert.assertEquals((int)ContainerValueExtractorCountCalls.callCounter, (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="valueextractordefinition", id="c"), @SpecAssertion(section="valueextractordefinition", id="g"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="a"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="c")})
    public void value() {
        Container<ContainerElement> container = new Container<ContainerElement>(CustomConstraint.INSTANCE);
        ContainerHolder containerHolder = new ContainerHolder(container);
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new ValueContainerValueExtractor()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)containerHolder, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("container").containerElement("<node name>", false, null, null, Container.class, 0));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="valueextractordefinition", id="d"), @SpecAssertion(section="valueextractordefinition", id="g"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="a"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="c")})
    public void iterableValue() {
        Container<ContainerElement> container = new Container<ContainerElement>(CustomConstraint.INSTANCE);
        ContainerHolder containerHolder = new ContainerHolder(container);
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IterableValueContainerValueExtractor()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)containerHolder, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("container").containerElement("<node name>", true, null, null, Container.class, 0));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="valueextractordefinition", id="e"), @SpecAssertion(section="valueextractordefinition", id="g"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="a"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="c")})
    public void indexedValue() {
        Container<ContainerElement> container = new Container<ContainerElement>(CustomConstraint.INSTANCE);
        ContainerHolder containerHolder = new ContainerHolder(container);
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IndexedValueContainerValueExtractor()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)containerHolder, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("container").containerElement("<node name>", true, null, 13, Container.class, 0));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="valueextractordefinition", id="f"), @SpecAssertion(section="valueextractordefinition", id="g"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="a"), @SpecAssertion(section="valueextractordefinition-extractedvalue", id="c")})
    public void keyedValue() {
        Container<ContainerElement> container = new Container<ContainerElement>(CustomConstraint.INSTANCE);
        ContainerHolder containerHolder = new ContainerHolder(container);
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new KeyedValueContainerValueExtractor()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)containerHolder, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("container").containerElement("<node name>", true, "key", null, Container.class, 0));
    }

    @Test
    @SpecAssertion(section="valueextractordefinition", id="h")
    public void nullNodeName() {
        Container<ContainerElement> container = new Container<ContainerElement>(CustomConstraint.INSTANCE);
        ContainerHolder containerHolder = new ContainerHolder(container);
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new NullNodeNameContainerValueExtractor()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)containerHolder, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("container"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="valueextractordefinition", id="j"), @SpecAssertion(section="valueextractordefinition", id="k")})
    public void valuePassedToExtractorRetrievedFromHost() {
        HashMap<String, Order> propertyMap = new HashMap<String, Order>();
        propertyMap.put("name1", new Order("INVALID-ID"));
        propertyMap.put("name2", new Order(null));
        propertyMap.put(null, new Order("RETAIL-1"));
        HashMap<String, Order> getterMap = new HashMap<String, Order>();
        getterMap.put(null, new Order("RETAIL-2"));
        getterMap.put("name2", new Order("INVALID-ID"));
        MapHolder mapHolder = new MapHolder(propertyMap, getterMap);
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new LocalMapValueExtractor(propertyMap)).addValueExtractor((ValueExtractor)new LocalMapKeyExtractor(getterMap)).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)mapHolder, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(RetailOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("ordersByName").containerElement("<map value>", true, "name1", null, Map.class, 1)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("ordersByName").property("id", true, "name2", null, Map.class, 1)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("ordersByName").containerElement("<map key>", true, null, null, Map.class, 0)));
    }

    private static class StringContainerHolder {
        private final Container<@NotNull String> container;

        private StringContainerHolder(Container<String> container) {
            this.container = container;
        }
    }

    private static class ContainerHolder {
        private final Container<@CustomConstraint ContainerElement> container;

        private ContainerHolder(Container<ContainerElement> container) {
            this.container = container;
        }
    }

    private static class MapHolder {
        private final Map<String, @Valid @RetailOrder Order> ordersByName;
        private final Map<String, Order> getterMap;

        private MapHolder(Map<String, Order> propertyMap, Map<String, Order> getterMap) {
            this.ordersByName = propertyMap;
            this.getterMap = getterMap;
        }

        public Map<@NotNull String, Order> getOrdersByName() {
            return this.getterMap;
        }
    }
}

