/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.util.shrinkwrap;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.ArchiveBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.WebAppVersionType;

public class WebArchiveBuilder
extends ArchiveBuilder<WebArchiveBuilder, WebArchive> {
    private static String BEANS_XML = "<beans xmlns=\"https://jakarta.ee/xml/ns/jakartaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"https://jakarta.ee/xml/ns/jakartaee https://jakarta.ee/xml/ns/jakartaee/beans_3_0.xsd\"\nbean-discovery-mode=\"all\"></beans>";
    private List<ArchiveBuilder.ResourceDescriptor> webInfResources = null;

    @Override
    public WebArchiveBuilder self() {
        return this;
    }

    @Override
    protected WebArchive buildInternal() {
        WebArchive webArchive = this.getName() == null ? (WebArchive)ShrinkWrap.create(WebArchive.class) : (WebArchive)ShrinkWrap.create(WebArchive.class, (String)this.getName());
        this.processPackages((ClassContainer<?>)webArchive);
        this.processClasses((ClassContainer<?>)webArchive);
        this.processResources((ResourceContainer<?>)webArchive);
        this.processWebInfResources(webArchive);
        this.processAdditionalJars((LibraryContainer<?>)webArchive);
        WebAppDescriptor webAppDescriptor = ((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).version(WebAppVersionType._3_0);
        webArchive.setWebXML((Asset)new StringAsset(webAppDescriptor.exportAsString()));
        return webArchive;
    }

    @Override
    public WebArchiveBuilder withEmptyBeansXml() {
        return this.withWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    public WebArchiveBuilder withBeansXml() {
        return this.withWebInfResource((Asset)new StringAsset(BEANS_XML), "beans.xml");
    }

    private WebArchiveBuilder withWebInfResource(Asset asset, String target) {
        if (this.webInfResources == null) {
            this.webInfResources = new ArrayList<ArchiveBuilder.ResourceDescriptor>();
        }
        this.webInfResources.add(new ArchiveBuilder.ResourceDescriptor(asset, target));
        return this.self();
    }

    private void processWebInfResources(WebArchive archive) {
        if (this.webInfResources == null) {
            return;
        }
        for (ArchiveBuilder.ResourceDescriptor resource : this.webInfResources) {
            if (resource.getSource() != null) {
                if (resource.getTarget() == null) {
                    archive.addAsWebInfResource(resource.getSource());
                    continue;
                }
                archive.addAsWebInfResource(resource.getSource(), resource.getTarget());
                continue;
            }
            if (resource.getAsset() == null) continue;
            archive.addAsWebInfResource(resource.getAsset(), resource.getTarget());
        }
    }
}

