/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.testng.IHookCallBack;
import org.testng.ITestResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractBootstrapFailureTCKTest
extends AbstractTCKTest {
    private Exception acceptedDeploymentException;

    protected abstract Class<? extends Exception> acceptedDeploymentExceptionType();

    @BeforeClass(groups={"arquillian"}, inheritGroups=true)
    public void arquillianBeforeClass() throws Exception {
        block2: {
            try {
                super.arquillianBeforeClass();
            }
            catch (Exception e) {
                this.acceptedDeploymentException = AbstractBootstrapFailureTCKTest.extractAcceptedDeploymentException(this.acceptedDeploymentExceptionType(), e);
                if (this.acceptedDeploymentException != null) break block2;
                throw e;
            }
        }
    }

    @BeforeMethod(groups={"arquillian"}, inheritGroups=true)
    public void arquillianBeforeTest(Method testMethod) throws Exception {
        if (this.acceptedDeploymentException != null) {
            return;
        }
        super.arquillianBeforeTest(testMethod);
    }

    public void run(IHookCallBack callback, ITestResult testResult) {
        if (this.acceptedDeploymentException != null) {
            testResult.setStatus(2);
            testResult.setThrowable((Throwable)this.acceptedDeploymentException);
            return;
        }
        super.run(callback, testResult);
    }

    private static Exception extractAcceptedDeploymentException(Class<? extends Exception> acceptedDeploymentExceptionType, Throwable exception) {
        Exception exception2;
        Exception exception3;
        if (acceptedDeploymentExceptionType.isAssignableFrom(exception.getClass())) {
            return (Exception)exception;
        }
        if (exception instanceof InvocationTargetException && (exception3 = AbstractBootstrapFailureTCKTest.extractAcceptedDeploymentException(acceptedDeploymentExceptionType, ((InvocationTargetException)exception).getTargetException())) != null) {
            return exception3;
        }
        if (exception.getCause() != null && (exception2 = AbstractBootstrapFailureTCKTest.extractAcceptedDeploymentException(acceptedDeploymentExceptionType, exception.getCause())) != null) {
            return exception2;
        }
        for (Throwable suppressedException : exception.getSuppressed()) {
            Exception acceptedDeploymentException2 = AbstractBootstrapFailureTCKTest.extractAcceptedDeploymentException(acceptedDeploymentExceptionType, suppressedException);
            if (acceptedDeploymentException2 == null) continue;
            return acceptedDeploymentException2;
        }
        if (exception.getMessage().contains(acceptedDeploymentExceptionType.getName())) {
            try {
                Constructor<? extends Exception> constructor = acceptedDeploymentExceptionType.getConstructor(String.class);
                return constructor.newInstance("Forged exception");
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception4) {
                // empty catch block
            }
        }
        return null;
    }
}

