/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.factory;

import jakarta.inject.Inject;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.factory.GreetingConstraint;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ConstraintValidatorInjectionTest
extends AbstractTCKTest {
    @Inject
    private ValidatorFactory defaultValidatorFactory;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ConstraintValidatorInjectionTest.webArchiveBuilder().withTestClassPackage(ConstraintValidatorInjectionTest.class)).withBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-objectslifecycle", id="c"), @SpecAssertion(section="integration-dependencyinjection", id="a"), @SpecAssertion(section="integration-dependencyinjection-customconfiguration", id="c")})
    public void testDependencyInjectionIntoConstraintValidator() {
        Set violations = this.defaultValidatorFactory.getValidator().validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(GreetingConstraint.class).withMessage("Hello, Mr. bar!"), ConstraintViolationAssert.violationOf(GreetingConstraint.class).withMessage("Good morning, Mr. qux!"));
    }

    private static class Foo {
        @GreetingConstraint(name="bar")
        public String bar;
        @GreetingConstraint(name="qux")
        public Integer qux;

        private Foo() {
        }
    }
}

