/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.TimerEventHandler;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

class TransactionReaper
implements TimerEventHandler {
    TransactionList translist = null;
    Logger logger = Globals.getLogger();
    List<TIDEntry> committed = Collections.synchronizedList(new ArrayList());
    List<TIDEntry> noremoves = Collections.synchronizedList(new ArrayList());
    List<TIDEntry> clusterPCommitted = Collections.synchronizedList(new ArrayList());
    List<TIDEntry> remoteCommitted = Collections.synchronizedList(new ArrayList());
    List<TIDEntry> remoteRCommitted = Collections.synchronizedList(new ArrayList());
    WakeupableTimer reapTimer = null;

    public TransactionReaper(TransactionList tl) {
        this.translist = tl;
    }

    private boolean needReapOne(List l) {
        if (TransactionList.TXN_REAPLIMIT == 0) {
            return true;
        }
        int size = l.size();
        return (double)size > (double)TransactionList.TXN_REAPLIMIT * (1.0 + (double)((float)TransactionList.TXN_REAPLIMIT_OVERTHRESHOLD / 100.0f));
    }

    public void addLocalTransaction(TransactionUID tid, boolean noremove) {
        TIDEntry e = new TIDEntry(tid);
        if (noremove) {
            this.noremoves.add(e);
        }
        this.committed.add(e);
        this.createTimer();
        if (this.committed.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
        if (this.needReapOne(this.committed)) {
            this.run(true);
        }
    }

    public void addClusterTransaction(TransactionUID tid, boolean noremove) {
        this.addClusterTransaction(tid, noremove, false);
    }

    public void addClusterTransaction(TransactionUID tid, boolean noremove, boolean takeover) {
        TIDEntry e = null;
        e = !takeover ? new TIDEntry(tid, ClusterPCommittedState.UNPROCCESSED) : new TIDEntry(tid, ClusterPCommittedState.TAKEOVER);
        this.clusterPCommitted.add(e);
        if (noremove) {
            this.noremoves.add(e);
        }
        this.createTimer();
        this.reapTimer.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterTransactionCompleted(TransactionUID tid) {
        TransactionBroker[] brokers;
        block18: {
            this.createTimer();
            this.reapTimer.wakeup();
            if (!this.needReapOne(this.clusterPCommitted) && !this.needReapOne(this.committed)) {
                return;
            }
            brokers = null;
            try {
                brokers = this.translist.getClusterTransactionBrokers(tid);
            }
            catch (Exception e) {
                boolean logstack = true;
                if (e instanceof BrokerException && ((BrokerException)e).getStatusCode() == 404) {
                    logstack = false;
                }
                BrokerResources cfr_ignored_0 = this.translist.br;
                String emsg = this.translist.br.getKString("B2274", tid, e.getMessage());
                if (logstack) {
                    this.logger.logStack(16, emsg, e);
                }
                if (!TransactionList.DEBUG) break block18;
                this.logger.log(8, emsg + " - all completed");
            }
        }
        boolean completed = true;
        if (brokers == null) {
            completed = false;
        } else {
            for (int i = 0; i < brokers.length; ++i) {
                if (brokers[i].isCompleted()) continue;
                completed = false;
            }
        }
        if (completed) {
            TIDEntry entry = null;
            TIDEntry e = new TIDEntry(tid);
            List<TIDEntry> list = this.clusterPCommitted;
            synchronized (list) {
                int ind = this.clusterPCommitted.indexOf(e);
                if (ind >= 0) {
                    entry = this.clusterPCommitted.get(ind);
                }
                if (entry != null && entry.inprocessing) {
                    entry = null;
                }
                if (entry != null) {
                    entry.inprocessing = true;
                }
            }
            if (entry != null) {
                if (entry.pstate == ClusterPCommittedState.UNPROCCESSED) {
                    Globals.getConnectionManager().removeFromClientDataList("transaction", entry.tid);
                }
                entry.pstate = ClusterPCommittedState.PROCCESSED;
                this.clusterPCommitted.remove(entry);
                entry.inprocessing = false;
                this.committed.add(entry);
            }
        }
        if (this.needReapOne(this.committed)) {
            this.run(true);
        }
    }

    public void addRemoteTransaction(TransactionUID tid, boolean recovery) {
        TIDEntry e = new TIDEntry(tid);
        if (!recovery) {
            this.remoteCommitted.add(e);
        } else {
            this.remoteRCommitted.add(e);
        }
        this.createTimer();
        if (this.remoteCommitted.size() > TransactionList.TXN_REAPLIMIT || this.remoteRCommitted.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
        if (this.needReapOne(this.remoteCommitted) || this.needReapOne(this.remoteRCommitted)) {
            this.run(true);
        }
    }

    public boolean hasRemoteTransaction(TransactionUID tid) {
        TIDEntry e = new TIDEntry(tid);
        if (this.remoteCommitted.contains(e)) {
            return true;
        }
        return this.remoteRCommitted.contains(e);
    }

    public synchronized void wakeupReaperTimer() {
        if (this.reapTimer != null) {
            this.reapTimer.wakeup();
        }
    }

    private synchronized void createTimer() {
        if (this.reapTimer == null) {
            try {
                String startString = Globals.getBrokerResources().getKString("B1285", TransactionList.TXN_REAPLIMIT, TransactionList.TXN_REAPINTERVAL / 1000L);
                String exitString = Globals.getBrokerResources().getKString("B1286");
                this.reapTimer = new WakeupableTimer("TransactionReaper", this, TransactionList.TXN_REAPINTERVAL, TransactionList.TXN_REAPINTERVAL, startString, exitString);
            }
            catch (Throwable ex) {
                String emsg = Globals.getBrokerResources().getKString("B3278", ex.getMessage());
                this.logger.logStack(32, emsg, ex);
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), emsg, BrokerEvent.Type.RESTART, ex, false, true, false);
            }
        }
    }

    @Override
    public void handleOOMError(Throwable e) {
        Globals.handleGlobalError(e, "OOM:TransactionReaper");
    }

    @Override
    public void handleLogInfo(String msg) {
        this.logger.log(8, msg);
    }

    @Override
    public void handleLogWarn(String msg, Throwable e) {
        if (e == null) {
            this.logger.log(16, msg);
        } else {
            this.logger.logStack(16, msg, e);
        }
    }

    @Override
    public void handleLogError(String msg, Throwable e) {
        if (e == null) {
            this.logger.log(32, msg);
        } else {
            this.logger.logStack(32, msg, e);
        }
    }

    @Override
    public void handleTimerExit(Throwable e) {
        if (BrokerStateHandler.isShuttingDown() || this.reapTimer == null) {
            return;
        }
        String emsg = Globals.getBrokerResources().getKString("B3279", e.getMessage());
        Broker broker = Broker.getBroker();
        Globals.getBrokerStateHandler();
        broker.exit(BrokerStateHandler.getRestartCode(), emsg, BrokerEvent.Type.RESTART, e, false, true, false);
    }

    public synchronized void destroy() {
        if (this.reapTimer != null) {
            this.reapTimer.cancel();
            this.reapTimer = null;
        }
        this.committed.clear();
        this.remoteCommitted.clear();
        this.remoteRCommitted.clear();
    }

    public Hashtable getDebugState(TransactionUID id) {
        TIDEntry e = new TIDEntry(id);
        Hashtable<Object, String> ht = new Hashtable<Object, String>();
        if (this.committed.contains(e)) {
            ht.put(id.toString(), TransactionState.toString(6));
            return ht;
        }
        if (this.clusterPCommitted.contains(e)) {
            ht.put(id.toString() + "(cluster)", TransactionState.toString(6));
            return ht;
        }
        if (this.remoteCommitted.contains(e)) {
            ht.put(id.toString() + "(remote)", TransactionState.toString(6));
            return ht;
        }
        if (this.remoteRCommitted.contains(e)) {
            ht.put(id.toString() + "(remote-r)", TransactionState.toString(6));
            return ht;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
        ArrayList<TIDEntry> l = null;
        ht.put("committedCount", this.committed.size());
        List<TIDEntry> list = this.committed;
        synchronized (list) {
            l = new ArrayList<TIDEntry>(this.committed);
        }
        TIDEntry e2 = null;
        for (TIDEntry e2 : l) {
            ht.put(e2.tid.toString(), TransactionState.toString(6) + ":" + e2.inprocessing);
        }
        l.clear();
        ht.put("clusterPCommittedCount", this.clusterPCommitted.size());
        List<TIDEntry> list2 = this.clusterPCommitted;
        synchronized (list2) {
            l = new ArrayList<TIDEntry>(this.clusterPCommitted);
        }
        for (TIDEntry e2 : l) {
            ht.put(e2.tid.toString() + "(cluster)", TransactionState.toString(6) + ":" + e2.inprocessing + ":" + e2.pstate);
        }
        l.clear();
        ht.put("noremovesCount", this.noremoves.size());
        list2 = this.noremoves;
        synchronized (list2) {
            l = new ArrayList<TIDEntry>(this.noremoves);
        }
        for (TIDEntry e2 : l) {
            ht.put(e2.tid.toString(), TransactionState.toString(6));
        }
        l.clear();
        ht.put("remoteCommittedCount", this.remoteCommitted.size());
        list2 = this.remoteCommitted;
        synchronized (list2) {
            l = new ArrayList<TIDEntry>(this.remoteCommitted);
        }
        for (TIDEntry e2 : l) {
            ht.put(e2.tid.toString() + "(remote)", TransactionState.toString(6) + ":" + e2.inprocessing);
        }
        l.clear();
        ht.put("remoteRCommittedCount", this.remoteRCommitted.size());
        list2 = this.remoteRCommitted;
        synchronized (list2) {
            l = new ArrayList<TIDEntry>(this.remoteRCommitted);
        }
        for (TIDEntry e2 : l) {
            ht.put(e2.tid.toString() + "(remote-r)", TransactionState.toString(6) + ":" + e2.inprocessing);
        }
        l.clear();
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clusterPCommittedHasUnprocessed() {
        ArrayList<TIDEntry> l = null;
        List<TIDEntry> list = this.clusterPCommitted;
        synchronized (list) {
            l = new ArrayList<TIDEntry>(this.clusterPCommitted);
        }
        TIDEntry e2 = null;
        for (TIDEntry e2 : l) {
            if (e2.pstate != ClusterPCommittedState.UNPROCCESSED && e2.pstate != ClusterPCommittedState.TAKEOVER) continue;
            return true;
        }
        l.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSwipeMark(List<TIDEntry> list) {
        ArrayList<TIDEntry> l = null;
        List<TIDEntry> list2 = list;
        synchronized (list2) {
            l = new ArrayList<TIDEntry>(list);
        }
        TIDEntry e2 = null;
        for (TIDEntry e2 : l) {
            e2.swipemark = false;
        }
        l.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIDEntry getNextEntry(List<TIDEntry> l, int limit, boolean swipe) {
        TIDEntry entry = null;
        int i = 0;
        int rsize = 0;
        List<TIDEntry> list = l;
        synchronized (list) {
            rsize = l.size();
            while (rsize > limit) {
                entry = l.get(i++);
                if (entry.inprocessing) {
                    --rsize;
                    entry = null;
                    continue;
                }
                if (!swipe && (entry.swipeonly || entry.swipemark)) {
                    --rsize;
                    entry = null;
                    continue;
                }
                if (swipe && entry.swipemark) {
                    --rsize;
                    entry = null;
                    continue;
                }
                entry.inprocessing = true;
                if (!swipe) break;
                entry.swipemark = true;
                break;
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseNextEntry(List<TIDEntry> l, TIDEntry entry) {
        if (l == null) {
            entry.inprocessing = false;
            return;
        }
        List<TIDEntry> list = l;
        synchronized (list) {
            entry.inprocessing = false;
        }
    }

    @Override
    public long runTask() {
        try {
            this.run(false);
        }
        finally {
            this.clearSwipeMark(this.clusterPCommitted);
            this.clearSwipeMark(this.committed);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean oneOnly) {
        if (!this.translist.isLoadComplete()) {
            if (oneOnly) {
                return;
            }
            try {
                this.logger.log(8, Globals.getBrokerResources().getString("B1327"));
                this.translist.loadCompleteLatch.await(TransactionList.TXN_REAPINTERVAL, TimeUnit.MILLISECONDS);
                if (!this.translist.isLoadComplete()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                this.logger.log(16, "Transaction reaper thread is interrupted in waiting for transaction loading completion");
                return;
            }
        }
        ArrayList activatedBrokers = null;
        ArrayList activatedPartitions = null;
        if (!oneOnly) {
            Vector vector = this.translist.newlyActivatedBrokers;
            synchronized (vector) {
                activatedBrokers = new ArrayList(this.translist.newlyActivatedBrokers);
                this.translist.newlyActivatedBrokers.clear();
            }
            vector = this.translist.newlyActivatedPartitions;
            synchronized (vector) {
                activatedPartitions = new ArrayList(this.translist.newlyActivatedPartitions);
                this.translist.newlyActivatedPartitions.clear();
            }
        }
        TIDEntry entry = null;
        TIDEntry tmpe = null;
        int count = 0;
        while (this.reapTimer != null && (count <= 0 || entry != null && !oneOnly)) {
            entry = null;
            ++count;
            if (!oneOnly && (activatedBrokers.size() > 0 || activatedPartitions.size() > 0 || this.clusterPCommittedHasUnprocessed()) && (tmpe = this.getNextEntry(this.clusterPCommitted, 0, !oneOnly)) != null) {
                entry = tmpe;
                TransactionUID cpcTid = entry.tid;
                ClusterPCommittedState processState = entry.pstate;
                if (processState != null && processState == ClusterPCommittedState.UNPROCCESSED) {
                    Globals.getConnectionManager().removeFromClientDataList("transaction", cpcTid);
                }
                try {
                    UID tranpid = this.translist.getPartitionedStore().getPartitionID();
                    TransactionBroker[] brokers = this.translist.getClusterTransactionBrokers(cpcTid);
                    boolean completed = true;
                    if (brokers != null) {
                        BrokerAddress to = null;
                        for (int j = 0; j < brokers.length; ++j) {
                            if (brokers[j].isCompleted()) continue;
                            completed = false;
                            to = brokers[j].getCurrentBrokerAddress();
                            if (to != null) {
                                if (to.equals(Globals.getMyAddress()) && to.equals(brokers[j].getBrokerAddress())) {
                                    TransactionList transactionList = this.translist;
                                    if (!transactionList.DL.isPartitionMode() || tranpid.equals(brokers[j].getBrokerAddress().getStoreSessionUID())) {
                                        try {
                                            this.translist.completeClusterTransactionBrokerState(cpcTid, 6, to, true);
                                        }
                                        catch (Exception e) {
                                            this.logger.logStack(16, "Unable to update transaction broker state for " + to + ", TUID=" + cpcTid, e);
                                        }
                                        if (!Globals.getHAEnabled()) continue;
                                    }
                                }
                                if (activatedBrokers.size() == 0 && activatedPartitions.size() == 0 && processState != null && processState == ClusterPCommittedState.PROCCESSED || activatedBrokers.size() == 0 && !to.equals(Globals.getMyAddress()) && processState != null && processState != ClusterPCommittedState.TAKEOVER || activatedBrokers.size() > 0 && !activatedBrokers.contains(to.getMQAddress()) && !to.equals(Globals.getMyAddress()) && processState != null && processState != ClusterPCommittedState.TAKEOVER) continue;
                                if (TransactionList.DEBUG_CLUSTER_TXN) {
                                    this.logger.log(8, "txnReaperThread: sendClusterTransactionInfo for TID=" + cpcTid + " to " + to);
                                }
                                Globals.getClusterBroadcast().sendClusterTransactionInfo(cpcTid.longValue(), to);
                                continue;
                            }
                            if (processState == null || processState == ClusterPCommittedState.PROCCESSED) continue;
                            this.logger.log(8, Globals.getBrokerResources().getKString("B2205", cpcTid.toString(), brokers[j].toString()));
                        }
                    }
                    entry.pstate = ClusterPCommittedState.PROCCESSED;
                    if (!completed) {
                        this.releaseNextEntry(this.clusterPCommitted, entry);
                    } else {
                        this.clusterPCommitted.remove(entry);
                        this.releaseNextEntry(null, entry);
                        this.committed.add(entry);
                    }
                }
                catch (Throwable e) {
                    this.logger.logStack(16, e.getMessage(), e);
                }
            }
            if ((tmpe = this.getNextEntry(this.committed, TransactionList.TXN_REAPLIMIT, !oneOnly)) != null) {
                entry = tmpe;
                if (TransactionList.DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Cleaning up committed transaction " + entry.tid);
                }
                try {
                    try {
                        this.translist.reapTransactionID(entry.tid, this.noremoves.contains(entry));
                    }
                    catch (BrokerException e) {
                        if (e.getStatusCode() != 404) {
                            this.releaseNextEntry(this.committed, entry);
                            entry.swipeonly = true;
                            throw e;
                        }
                        this.logger.logStack(16, "Cleanup committed transaction: " + e.getMessage(), e);
                    }
                    this.committed.remove(entry);
                    this.noremoves.remove(entry);
                }
                catch (Exception e) {
                    this.logger.logStack(16, "Failed to cleanup committed transaction " + entry.tid, e);
                }
            }
            if ((tmpe = this.getNextEntry(this.remoteCommitted, TransactionList.TXN_REAPLIMIT, !oneOnly)) != null) {
                entry = tmpe;
                this.remoteCommitted.remove(entry);
                if (TransactionList.DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Cleaned up committed remote transaction " + entry.tid);
                }
            }
            if ((tmpe = this.getNextEntry(this.remoteRCommitted, TransactionList.TXN_REAPLIMIT, !oneOnly)) == null) continue;
            entry = tmpe;
            this.remoteRCommitted.remove(entry);
            if (!TransactionList.DEBUG_CLUSTER_TXN) continue;
            this.logger.log(8, "Cleaned up committed remote transaction " + entry.tid);
        }
    }

    static class TIDEntry {
        TransactionUID tid = null;
        boolean inprocessing = false;
        ClusterPCommittedState pstate = ClusterPCommittedState.UNPROCCESSED;
        boolean swipemark = false;
        boolean swipeonly = false;

        public TIDEntry(TransactionUID id) {
            this.tid = id;
        }

        public TIDEntry(TransactionUID id, ClusterPCommittedState s) {
            this.tid = id;
            this.pstate = s;
        }

        public int hashCode() {
            return this.tid.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TIDEntry) {
                return this.tid.equals(((TIDEntry)obj).tid);
            }
            return false;
        }
    }

    static enum ClusterPCommittedState {
        UNPROCCESSED,
        PROCCESSED,
        TAKEOVER;

    }
}

