/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import jakarta.servlet.annotation.ServletSecurity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.exousia.constraints.SecurityConstraint;
import org.glassfish.exousia.constraints.WebResourceCollection;
import org.glassfish.exousia.mapping.SecurityRoleRef;

public class GlassFishToExousiaConverter {
    public static List<SecurityConstraint> getConstraintsFromBundle(WebBundleDescriptor webBundleDescriptor) {
        ArrayList<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();
        for (com.sun.enterprise.deployment.web.SecurityConstraint glassFishSecurityConstraint : Collections.list(webBundleDescriptor.getSecurityConstraints())) {
            ArrayList<WebResourceCollection> webResourceCollections = new ArrayList<WebResourceCollection>();
            for (com.sun.enterprise.deployment.web.WebResourceCollection glassFishCollection : glassFishSecurityConstraint.getWebResourceCollections()) {
                webResourceCollections.add(new WebResourceCollection(glassFishCollection.getUrlPatterns(), glassFishCollection.getHttpMethods(), glassFishCollection.getHttpMethodOmissions()));
            }
            constraints.add(new SecurityConstraint(webResourceCollections, GlassFishToExousiaConverter.securityRoles(glassFishSecurityConstraint), "confidential".equalsIgnoreCase(GlassFishToExousiaConverter.transportGuarantee(glassFishSecurityConstraint)) ? ServletSecurity.TransportGuarantee.CONFIDENTIAL : ServletSecurity.TransportGuarantee.NONE));
        }
        return constraints;
    }

    static Set<String> securityRoles(com.sun.enterprise.deployment.web.SecurityConstraint glassFishSecurityConstraint) {
        if (glassFishSecurityConstraint.getAuthorizationConstraint() == null) {
            return null;
        }
        return Collections.list(glassFishSecurityConstraint.getAuthorizationConstraint().getSecurityRoles()).stream().map(role -> role.getName()).collect(Collectors.toSet());
    }

    static String transportGuarantee(com.sun.enterprise.deployment.web.SecurityConstraint glassFishSecurityConstraint) {
        if (glassFishSecurityConstraint.getUserDataConstraint() == null) {
            return null;
        }
        return glassFishSecurityConstraint.getUserDataConstraint().getTransportGuarantee();
    }

    public static Map<String, List<SecurityRoleRef>> getSecurityRoleRefsFromBundle(WebBundleDescriptor webBundleDescriptor) {
        HashMap<String, List<SecurityRoleRef>> exousiaRoleRefsPerServlet = new HashMap<String, List<SecurityRoleRef>>();
        for (WebComponentDescriptor webComponent : webBundleDescriptor.getWebComponentDescriptors()) {
            ArrayList<SecurityRoleRef> exousiaSecurityRoleRefs = new ArrayList<SecurityRoleRef>();
            for (SecurityRoleReference glassFishSecurityRoleRef : webComponent.getSecurityRoleReferenceSet()) {
                exousiaSecurityRoleRefs.add(new SecurityRoleRef(glassFishSecurityRoleRef.getRoleName(), glassFishSecurityRoleRef.getSecurityRoleLink().getName()));
            }
            exousiaRoleRefsPerServlet.put(webComponent.getCanonicalName(), exousiaSecurityRoleRefs);
        }
        return exousiaRoleRefsPerServlet;
    }
}

