/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModulesRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.appclient.server.core.AppClientContainerStarter;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.AppClientServerApplication;
import org.glassfish.appclient.server.core.StandaloneAppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.JWSAdapterManager;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class AppClientDeployer
extends JavaEEDeployer<AppClientContainerStarter, AppClientServerApplication>
implements PostConstruct {
    private Logger logger;
    public static final String APPCLIENT_FACADE_CLASS_FILE = "org/glassfish/appclient/client/AppClientFacade.class";
    public static final String APPCLIENT_AGENT_MAIN_CLASS_FILE = "org/glassfish/appclient/client/JWSAppClientContainerMain.class";
    public static final String APPCLIENT_COMMAND_CLASS_NAME = "org.glassfish.appclient.client.AppClientFacade";
    public static final Attributes.Name GLASSFISH_APPCLIENT_MAIN_CLASS = new Attributes.Name("GlassFish-AppClient-Main-Class");
    public static final Attributes.Name SPLASH_SCREEN_IMAGE = new Attributes.Name("SplashScreen-Image");
    public static final Attributes.Name GLASSFISH_APP_NAME = new Attributes.Name("GlassFish-App-Name");
    private static final String GF_CLIENT_MODULE_NAME = "org.glassfish.main.appclient.gf-client-module";
    public static final String HELPER_KEY_NAME = "org.glassfish.appclient.server.core.helper";
    @Inject
    protected Domain domain;
    @Inject
    private ModulesRegistry modulesRegistry;
    @Inject
    private Applications applications;
    @Inject
    private ASJarSigner jarSigner;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    private final Map<String, String> appAndClientNameToUserFriendlyContextRoot = new HashMap<String, String>();
    private ClassLoader gfClientModuleClassLoader;
    private final Set<AppClientServerApplication> appClientApps = new HashSet<AppClientServerApplication>();

    public void postConstruct() {
        this.logger = Logger.getLogger("jakarta.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
        for (HK2Module module : this.modulesRegistry.getModules(GF_CLIENT_MODULE_NAME)) {
            this.gfClientModuleClassLoader = module.getClassLoader();
        }
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public AppClientServerApplication load(AppClientContainerStarter containerStarter, DeploymentContext dc) {
        ApplicationClientDescriptor appclientDesc = (ApplicationClientDescriptor)dc.getModuleMetaData(ApplicationClientDescriptor.class);
        if (appclientDesc == null) {
            return null;
        }
        appclientDesc.setClassLoader(dc.getClassLoader());
        AppClientDeployerHelper helper = null;
        try {
            helper = this.getSavedHelperOrCreateHelper(dc);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        AppClientServerApplication newACServerApp = this.newACServerApp(dc, helper);
        this.appClientApps.add(newACServerApp);
        return newACServerApp;
    }

    public Set<AppClientServerApplication> appClientApps() {
        return this.appClientApps;
    }

    private AppClientServerApplication newACServerApp(DeploymentContext dc, AppClientDeployerHelper helper) {
        AppClientServerApplication result = (AppClientServerApplication)this.habitat.getService(AppClientServerApplication.class, new Annotation[0]);
        result.init(dc, helper);
        return result;
    }

    public void unload(AppClientServerApplication application, DeploymentContext dc) {
        this.appClientApps.remove(application);
    }

    public void clean(DeploymentContext dc) {
        super.clean(dc);
        UndeployCommandParameters params = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        if (params != null) {
            com.sun.enterprise.config.serverbeans.Application app = this.applications.getApplication(params.name);
            DeploymentUtils.downloadableArtifacts((com.sun.enterprise.config.serverbeans.Application)app).clearArtifacts();
        }
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        if (dc.getModuleMetaData(ApplicationClientDescriptor.class) == null) {
            return;
        }
        try {
            AppClientDeployerHelper helper = this.createAndSaveHelper(dc, this.gfClientModuleClassLoader);
            helper.prepareJARs();
            this.addArtifactsToDownloads(helper, dc);
            this.addArtifactsToGeneratedFiles(helper, dc);
            this.recordUserFriendlyContextRoot(helper, dc);
        }
        catch (Exception ex) {
            throw new DeploymentException((Throwable)ex);
        }
    }

    private void recordUserFriendlyContextRoot(AppClientDeployerHelper helper, DeploymentContext dc) {
        String path = JWSAdapterManager.userFriendlyContextRoot(helper.appClientDesc(), dc.getAppProps());
        dc.getModuleProps().put("jws.user.friendly.path", path);
    }

    private void addArtifactsToDownloads(AppClientDeployerHelper helper, DeploymentContext dc) throws IOException {
        Artifacts downloadInfo = DeploymentUtils.downloadableArtifacts((DeploymentContext)dc);
        downloadInfo.addArtifacts(helper.earLevelDownloads());
        downloadInfo.addArtifacts(helper.clientLevelDownloads());
    }

    private void addArtifactsToGeneratedFiles(AppClientDeployerHelper helper, DeploymentContext dc) throws IOException {
        Artifacts generatedFileInfo = DeploymentUtils.generatedArtifacts((DeploymentContext)dc);
        generatedFileInfo.addArtifacts(helper.earLevelDownloads());
        generatedFileInfo.addArtifacts(helper.clientLevelDownloads());
    }

    private AppClientDeployerHelper createAndSaveHelper(DeploymentContext dc, ClassLoader clientModuleLoader) throws IOException {
        AppClientArchivist archivist = (AppClientArchivist)this.habitat.getService(AppClientArchivist.class, new Annotation[0]);
        AppClientDeployerHelper h = AppClientDeployerHelper.newInstance(dc, archivist, clientModuleLoader, this.habitat, this.jarSigner);
        dc.addTransientAppMetaData(HELPER_KEY_NAME + this.moduleURI(dc), (Object)h.proxy());
        return h;
    }

    private AppClientDeployerHelper getSavedHelperOrCreateHelper(DeploymentContext dc) throws IOException {
        String key = HELPER_KEY_NAME + this.moduleURI(dc);
        AppClientDeployerHelper h = null;
        AppClientDeployerHelper.Proxy p = (AppClientDeployerHelper.Proxy)dc.getTransientAppMetaData(key, AppClientDeployerHelper.Proxy.class);
        if (p != null) {
            h = p.helper();
        }
        if (h == null) {
            h = (AppClientDeployerHelper)dc.getTransientAppMetaData(key, StandaloneAppClientDeployerHelper.class);
        }
        if (h == null) {
            h = this.createAndSaveHelper(dc, this.gfClientModuleClassLoader);
        }
        return h;
    }

    private String moduleURI(DeploymentContext dc) {
        ApplicationClientDescriptor acd = (ApplicationClientDescriptor)dc.getModuleMetaData(ApplicationClientDescriptor.class);
        return acd.getModuleDescriptor().getArchiveUri();
    }

    public void recordContextRoot(String appName, String clientURIWithinEAR, String userFriendlyContextRoot) {
        this.appAndClientNameToUserFriendlyContextRoot.put(this.keyToAppAndClientNameMap(appName, clientURIWithinEAR), userFriendlyContextRoot);
    }

    public void removeContextRoot(String appName, String clientURIWithinEAR) {
        this.appAndClientNameToUserFriendlyContextRoot.remove(this.keyToAppAndClientNameMap(appName, clientURIWithinEAR));
    }

    public String userFriendlyContextRoot(String appName, String clientModuleURI) {
        return this.appAndClientNameToUserFriendlyContextRoot.get(this.keyToAppAndClientNameMap(appName, clientModuleURI));
    }

    private String keyToAppAndClientNameMap(String appName, String moduleURIText) {
        return appName + "/" + (moduleURIText == null ? appName : moduleURIText);
    }
}

