/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.manager.AutoClusterBrokerMap;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.SFSHAClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.SFSHAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SFSHABrokerInfoMap
extends HashMap
implements AutoClusterBrokerMap {
    private static final long serialVersionUID = 5895105903367080815L;
    transient SFSHAClusterManagerImpl parent = null;

    public SFSHABrokerInfoMap(SFSHAClusterManagerImpl manager) throws BrokerException {
        this.init(manager, null);
    }

    @Override
    public void init(ClusterManager mgr, MQAddress addr) throws BrokerException {
        this.parent = (SFSHAClusterManagerImpl)mgr;
        HashMap map = Globals.getStore().getAllBrokerInfos();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            HABrokerInfo bi = (HABrokerInfo)entry.getValue();
            SFSHAClusteredBrokerImpl cb = new SFSHAClusteredBrokerImpl(bi.getId(), bi, this.parent);
            this.put(key, cb);
            this.parent.brokerChanged(ClusterReason.ADDED, cb.getBrokerName(), null, cb, cb.getBrokerSessionUID(), null);
        }
    }

    @Override
    public void updateMap() throws BrokerException {
        this.updateMap(false);
    }

    @Override
    public void updateMap(boolean all) throws BrokerException {
        if (all) {
            this.updateHAMapForState(null);
        } else {
            this.updateHAMapForState(BrokerState.OPERATING);
        }
    }

    private void updateHAMapForState(BrokerState state) throws BrokerException {
        String key;
        HashMap map = null;
        map = state == null ? Globals.getStore().getAllBrokerInfos() : Globals.getStore().getAllBrokerInfoByState(state);
        for (Map.Entry entry : map.entrySet()) {
            key = (String)entry.getKey();
            HABrokerInfo bi = (HABrokerInfo)entry.getValue();
            HAClusteredBrokerImpl impl = (HAClusteredBrokerImpl)this.get(key);
            if (impl == null) {
                SFSHAClusteredBrokerImpl cb = new SFSHAClusteredBrokerImpl(bi.getId(), bi, this.parent);
                this.put(key, cb);
                this.parent.brokerChanged(ClusterReason.ADDED, cb.getBrokerName(), null, cb, cb.getBrokerSessionUID(), null);
                continue;
            }
            impl.update(bi);
        }
        if (state == null) {
            Iterator itr = this.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry;
                entry = itr.next();
                key = (String)entry.getKey();
                if (map.containsKey(key)) continue;
                itr.remove();
                HAClusteredBrokerImpl impl = (HAClusteredBrokerImpl)entry.getValue();
                this.parent.brokerChanged(ClusterReason.REMOVED, impl.getBrokerName(), impl, null, impl.getBrokerSessionUID(), null);
            }
        }
    }

    @Override
    public Object get(Object key) {
        return this.get(key, false);
    }

    @Override
    public Object get(Object key, boolean update) {
        Object o = super.get(key);
        if (o == null || update) {
            try {
                HABrokerInfo m = Globals.getStore().getBrokerInfo((String)key);
                if (m != null && o == null) {
                    SFSHAClusteredBrokerImpl cb = new SFSHAClusteredBrokerImpl((String)key, m, this.parent);
                    this.put(key, cb);
                    this.parent.brokerChanged(ClusterReason.ADDED, cb.getBrokerName(), null, cb, cb.getBrokerSessionUID(), null);
                    o = cb;
                }
                if (m != null && update) {
                    ((HAClusteredBrokerImpl)o).update(m);
                }
            }
            catch (BrokerException ex) {
                Globals.getLogger().logStack(16, "Exception while creating broker entry " + key, (Throwable)ex);
            }
        }
        return o;
    }
}

