/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.JMSServiceImpl;
import com.sun.messaging.jmq.jmsservice.ConsumerClosedNoDeliveryException;
import com.sun.messaging.jmq.jmsservice.JMSAck;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.util.HashMap;
import java.util.HashSet;

class SessionListener
implements EventListener,
Runnable {
    JMSServiceImpl parent;
    boolean valid = false;
    boolean destroyed = false;
    boolean stopped = true;
    boolean islocked = true;
    Session session = null;
    boolean sync = true;
    boolean sessionEvListenerRegistered = false;
    boolean started = false;
    HashMap consumers = new HashMap();
    Object sessionLock = new Object();
    Object sessionEL = null;
    boolean sessionLockNotify = false;
    HashSet cuidNotify = new HashSet();
    private static final long MAX_WAIT_FOR_SESSION_STOP = 90000L;

    public SessionListener(JMSServiceImpl svc, Session s) {
        this.parent = svc;
        this.session = s;
        this.parent.addListener(s.getSessionUID(), this);
    }

    public Packet getNextConsumerPacket(ConsumerUID cuid) {
        return this.getNextConsumerPacket(cuid, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Packet getNextConsumerPacket(ConsumerUID cuid, long timeout) {
        if (!this.sync) {
            throw new RuntimeException("Cannot invoke SessionListener.getNextConsumerPacket() when in asynchronous receiving mode");
        }
        c = Consumer.getConsumer(cuid);
        this.sync = true;
        if (timeout < 0L) {
            if (this.stopped != false) return null;
            if (!c.isBusy()) {
                return null;
            }
        }
        lock = c.addEventListener(this, EventType.BUSY_STATE_CHANGED, null);
        try {
            while (!c.isBusy() || this.stopped) {
                block31: {
                    block30: {
                        block29: {
                            block27: {
                                block32: {
                                    block28: {
                                        var6_5 = c.getConsumerUID();
                                        // MONITORENTER : var6_5
                                        var7_7 = this.sessionLock;
                                        // MONITORENTER : var7_7
                                        if (!this.stopped) break block27;
                                        if (timeout <= 0L) ** GOTO lbl38
                                        locktime = System.currentTimeMillis();
                                        try {
                                            this.sessionLock.wait(timeout);
                                        }
                                        catch (Exception var10_12) {
                                            // empty catch block
                                        }
                                        now = System.currentTimeMillis();
                                        if ((timeout -= now - locktime) > 0L) break block28;
                                        var12_13 = null;
                                        // MONITOREXIT : var7_7
                                        // MONITOREXIT : var6_5
                                        c.removeEventListener(lock);
                                        {
                                            catch (Exception var6_6) {
                                                continue;
                                            }
                                        }
                                        return var12_13;
                                    }
                                    break block32;
lbl38:
                                    // 1 sources

                                    if (timeout == 0L) {
                                        try {
                                            this.sessionLock.wait(timeout);
                                        }
                                        catch (Exception var8_9) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (!this.stopped) break block27;
                                var8_10 = null;
                                // MONITOREXIT : var7_7
                                // MONITOREXIT : var6_5
                                c.removeEventListener(lock);
                                return var8_10;
                            }
                            // MONITOREXIT : var7_7
                            if (this.cuidNotify.remove(c.getConsumerUID())) {
                                // MONITOREXIT : var6_5
                                continue;
                            }
                            if (timeout >= 0L) break block29;
                            c.removeEventListener(lock);
                            var7_7 = null;
                            // MONITOREXIT : var6_5
                            c.removeEventListener(lock);
                            return var7_7;
                        }
                        c.getConsumerUID().wait(timeout);
                        // MONITOREXIT : var6_5
                        if (!this.stopped) break block30;
                        var6_5 = null;
                        c.removeEventListener(lock);
                        return var6_5;
                    }
                    if (c.isBusy() || timeout <= 0L) break block31;
                    c.removeEventListener(lock);
                    var6_5 = null;
                    c.removeEventListener(lock);
                    return var6_5;
                }
            }
            c.removeEventListener(lock);
        }
        catch (Throwable var15_14) {
            c.removeEventListener(lock);
            throw var15_14;
        }
        var6_5 = c.getConsumerUID();
        // MONITORENTER : var6_5
        this.cuidNotify.remove(c.getConsumerUID());
        // MONITOREXIT : var6_5
        p = new Packet();
        if (this.session.fillNextPacket(p, cuid) == false) return this.getNextConsumerPacket(cuid, timeout);
        return p;
    }

    public void setAsyncListener(Consumer brokerC, com.sun.messaging.jmq.jmsservice.Consumer target) {
        if (target == null) {
            this.sync = true;
            ConsumerUID cuid = brokerC.getConsumerUID();
            this.consumers.remove(cuid);
            return;
        }
        this.sync = false;
        ConsumerUID cuid = brokerC.getConsumerUID();
        this.consumers.put(cuid, target);
        if (!this.sessionEvListenerRegistered) {
            this.sessionEL = this.session.addEventListener(this, EventType.BUSY_STATE_CHANGED, null);
            this.sessionEvListenerRegistered = true;
        }
        if (!this.started) {
            Thread thr = new Thread((Runnable)this, "Session" + this.session.getSessionUID());
            thr.start();
            this.started = true;
        }
    }

    @Override
    public void run() {
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.sync) {
            throw new RuntimeException("Cannot invoke SessionListener.process() when in synchronous receiving mode");
        }
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.destroyed) {
                this.valid = false;
                this.sessionLock.notifyAll();
                return;
            }
            this.valid = true;
        }
        while (this.valid) {
            Packet p;
            ConsumerUID uid;
            while (this.valid && (!this.session.isBusy() || this.stopped)) {
                object = this.sessionLock;
                synchronized (object) {
                    this.islocked = true;
                    this.sessionLock.notifyAll();
                    if (this.sessionLockNotify || !this.valid || this.stopped) {
                        this.sessionLockNotify = false;
                        continue;
                    }
                    try {
                        this.sessionLock.wait();
                    }
                    catch (Exception ex) {
                        Globals.getLogger().log(1, "Exception in sessionlock wait", (Throwable)ex);
                    }
                }
            }
            if (!this.valid) continue;
            object = this.sessionLock;
            synchronized (object) {
                this.sessionLockNotify = false;
                this.islocked = false;
            }
            if (!this.session.isBusy() || this.stopped || !this.valid || (uid = this.session.fillNextPacket(p = new Packet())) == null) continue;
            com.sun.messaging.jmq.jmsservice.Consumer con = (com.sun.messaging.jmq.jmsservice.Consumer)this.consumers.get(uid);
            try {
                JMSAck ack = null;
                ack = con.deliver((JMSPacket)p);
                if (ack == null) continue;
                long transactionId = ack.getTransactionId();
                long consumerId = ack.getConsumerId();
                SysMessageID sysMsgId = ack.getSysMessageID();
                TransactionUID txnUID = null;
                ConsumerUID conUID = null;
                if (transactionId != 0L) {
                    txnUID = new TransactionUID(transactionId);
                }
                if (consumerId != 0L) {
                    conUID = new ConsumerUID(consumerId);
                }
                IMQConnection cxn = this.parent.checkConnectionId(ack.getConnectionId(), "Listener Thread");
                SysMessageID[] ids = new SysMessageID[]{sysMsgId};
                ConsumerUID[] cids = new ConsumerUID[]{conUID};
                Globals.getProtocol().acknowledge(cxn, txnUID, false, 0, null, null, 0, ids, cids);
            }
            catch (Exception ex) {
                if (ex instanceof ConsumerClosedNoDeliveryException) {
                    if (!this.parent.getDEBUG()) continue;
                    Globals.getLogger().logStack(8, "DirectConsumer " + con + " is closed, message " + p.getSysMessageID() + " can not be deliverd", (Throwable)ex);
                    continue;
                }
                Globals.getLogger().logStack(32, Globals.getBrokerResources().getKString("B4444", p.getSysMessageID(), uid + " DirectConsumer[" + con + "]"), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccured(EventType type, Reason r, Object target, Object oldval, Object newval, Object userdata) {
        if (type != EventType.BUSY_STATE_CHANGED) {
            return;
        }
        if (target instanceof Consumer) {
            Consumer cc = (Consumer)target;
            ConsumerUID cuid = cc.getConsumerUID();
            if (cc.isBusy()) {
                ConsumerUID consumerUID = cuid;
                synchronized (consumerUID) {
                    this.cuidNotify.add(cuid);
                    cuid.notifyAll();
                }
            }
            return;
        }
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessionLockNotify = true;
            this.sessionLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSession() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.stopped = false;
            this.sessionLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSession(boolean dowait) {
        Object object = this.sessionLock;
        synchronized (object) {
            Object[] args;
            long starttime;
            this.stopped = true;
            this.sessionLock.notifyAll();
            if (!dowait) {
                return;
            }
            for (long totalwaited = 0L; this.valid && !this.islocked && totalwaited < 90000L; totalwaited += System.currentTimeMillis() - starttime) {
                args = new String[]{"DirectSession[" + this.session + "]"};
                Globals.getLogger().log(8, Globals.getBrokerResources().getKTString("B1498", args));
                starttime = System.currentTimeMillis();
                try {
                    this.sessionLock.wait(1500L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.valid && !this.islocked) {
                args = new String[]{"DirectSession[" + this.session + "]"};
                Globals.getLogger().log(16, Globals.getBrokerResources().getKTString("B2288", args));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.valid = false;
            this.destroyed = true;
            this.sessionLock.notifyAll();
        }
        this.session.removeEventListener(this.sessionEL);
        this.parent.removeListener(this.session.getSessionUID());
        this.consumers = null;
    }
}

