/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import org.glassfish.concurrent.config.ManagedScheduledExecutorService;
import org.glassfish.concurrent.runtime.deployer.BaseConfig;

public class ManagedScheduledExecutorServiceConfig
extends BaseConfig {
    private int hungAfterSeconds;
    private boolean hungLoggerPrintOnce;
    private long hungLoggerInitialDelaySeconds;
    private long hungLoggerIntervalSeconds;
    private boolean longRunningTasks;
    private int threadPriority;
    private int corePoolSize;
    private long keepAliveSeconds;
    private long threadLifeTimeSeconds;

    public ManagedScheduledExecutorServiceConfig(ManagedScheduledExecutorService config) {
        super(config.getJndiName(), config.getContextInfo(), config.getContextInfoEnabled());
        this.hungAfterSeconds = this.parseInt(config.getHungAfterSeconds(), 0);
        this.hungLoggerPrintOnce = Boolean.valueOf(config.getHungLoggerPrintOnce());
        this.hungLoggerInitialDelaySeconds = this.parseLong(config.getHungLoggerInitialDelaySeconds(), 60L);
        this.hungLoggerIntervalSeconds = this.parseLong(config.getHungLoggerIntervalSeconds(), 60L);
        this.longRunningTasks = Boolean.valueOf(config.getLongRunningTasks());
        this.threadPriority = this.parseInt(config.getThreadPriority(), 5);
        this.corePoolSize = this.parseInt(config.getCorePoolSize(), 0);
        this.keepAliveSeconds = this.parseLong(config.getKeepAliveSeconds(), 60L);
        this.threadLifeTimeSeconds = this.parseLong(config.getThreadLifetimeSeconds(), 0L);
    }

    public int getHungAfterSeconds() {
        return this.hungAfterSeconds;
    }

    public boolean isHungLoggerPrintOnce() {
        return this.hungLoggerPrintOnce;
    }

    public long getHungLoggerInitialDelaySeconds() {
        return this.hungLoggerInitialDelaySeconds;
    }

    public long getHungLoggerIntervalSeconds() {
        return this.hungLoggerIntervalSeconds;
    }

    public boolean isLongRunningTasks() {
        return this.longRunningTasks;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public long getThreadLifeTimeSeconds() {
        return this.threadLifeTimeSeconds;
    }

    @Override
    public BaseConfig.TYPE getType() {
        return BaseConfig.TYPE.MANAGED_SCHEDULED_EXECUTOR_SERVICE;
    }
}

