/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base;

import com.sun.appserv.jdbc.DataSource;
import com.sun.gjc.spi.ConnectionManagerImplementation;
import com.sun.gjc.spi.ConnectionRequestInfoImpl;
import com.sun.gjc.spi.ManagedConnectionFactoryImpl;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.util.MethodExecutor;
import com.sun.logging.LogDomains;
import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.LazyAssociatableConnectionManager;
import jakarta.resource.spi.LazyEnlistableConnectionManager;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;

public abstract class AbstractDataSource
implements javax.sql.DataSource,
Serializable,
DataSource,
Referenceable {
    private static final long serialVersionUID = 1L;
    protected static final Logger _logger = LogDomains.getLogger(ManagedConnectionFactoryImpl.class, (String)"javax.enterprise.resource.resourceadapter");
    protected ManagedConnectionFactoryImpl managedConnectionFactoryImpl;
    protected MethodExecutor executor;
    private ConnectionManager connectionManager;
    private int loginTimeout;
    private PrintWriter logWriter;
    private String description;
    private Reference reference;
    private ConnectionHolder.ConnectionType conType_;

    public AbstractDataSource(ManagedConnectionFactoryImpl managedConnectionFactoryImpl, ConnectionManager connectionManager) {
        this.managedConnectionFactoryImpl = managedConnectionFactoryImpl;
        this.executor = new MethodExecutor();
        if (connectionManager == null) {
            this.connectionManager = new ConnectionManagerImplementation();
        } else {
            this.connectionManager = connectionManager;
            this.conType_ = this.findConnectionType();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            ConnectionHolder connection = (ConnectionHolder)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactoryImpl, null);
            this.setConnectionType(connection);
            return connection;
        }
        catch (ResourceException re) {
            this.logNonTransientException(re);
            throw new SQLException(re.getMessage(), re);
        }
    }

    private void logNonTransientException(ResourceException re) {
        if (!"POOL-RECONFIGURED-1".equals(re.getErrorCode())) {
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
        }
    }

    @Override
    public Connection getConnection(String user, String pwd) throws SQLException {
        try {
            ConnectionRequestInfoImpl info = new ConnectionRequestInfoImpl(user, pwd.toCharArray());
            ConnectionHolder con = (ConnectionHolder)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactoryImpl, (ConnectionRequestInfo)info);
            this.setConnectionType(con);
            return con;
        }
        catch (ResourceException re) {
            this.logNonTransientException(re);
            throw new SQLException(re.getMessage(), re);
        }
    }

    public Connection getConnection(Connection con) throws SQLException {
        Connection driverCon = con;
        if (con instanceof ConnectionHolder) {
            driverCon = ((ConnectionHolder)con).getConnection();
        }
        return driverCon;
    }

    public Connection getNonTxConnection() throws SQLException {
        try {
            ConnectionHolder connection = (ConnectionHolder)((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.connectionManager).allocateNonTxConnection((ManagedConnectionFactory)this.managedConnectionFactoryImpl, null);
            this.setConnectionType(connection, true);
            return connection;
        }
        catch (ResourceException re) {
            this.logNonTransientException(re);
            throw new SQLException(re.getMessage(), re);
        }
    }

    public Connection getNonTxConnection(String user, String password) throws SQLException {
        try {
            ConnectionRequestInfoImpl cxReqInfo = new ConnectionRequestInfoImpl(user, password.toCharArray());
            ConnectionHolder con = (ConnectionHolder)((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.connectionManager).allocateNonTxConnection((ManagedConnectionFactory)this.managedConnectionFactoryImpl, (ConnectionRequestInfo)cxReqInfo);
            this.setConnectionType(con, true);
            return con;
        }
        catch (ResourceException re) {
            this.logNonTransientException(re);
            throw new SQLException(re.getMessage(), re);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    private ConnectionHolder.ConnectionType findConnectionType() {
        ConnectionHolder.ConnectionType cmType = ConnectionHolder.ConnectionType.STANDARD;
        if (this.connectionManager instanceof LazyAssociatableConnectionManager) {
            if (!((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.connectionManager).getJndiName().endsWith("__pm")) {
                cmType = ConnectionHolder.ConnectionType.LAZY_ASSOCIATABLE;
            }
        } else if (this.connectionManager instanceof LazyEnlistableConnectionManager && !((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.connectionManager).getJndiName().endsWith("__pm") && !((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.connectionManager).getJndiName().endsWith("__nontx")) {
            cmType = ConnectionHolder.ConnectionType.LAZY_ENLISTABLE;
        }
        return cmType;
    }

    private void setConnectionType(ConnectionHolder con) {
        this.setConnectionType(con, false);
    }

    private void setConnectionType(ConnectionHolder con, boolean isNonTx) {
        con.setConnectionType(this.conType_);
        if (this.conType_ == ConnectionHolder.ConnectionType.LAZY_ASSOCIATABLE && this.connectionManager instanceof LazyAssociatableConnectionManager) {
            con.setLazyAssociatableConnectionManager((LazyAssociatableConnectionManager)this.connectionManager);
        } else if (this.conType_ == ConnectionHolder.ConnectionType.LAZY_ENLISTABLE) {
            if (isNonTx) {
                con.setConnectionType(ConnectionHolder.ConnectionType.STANDARD);
            } else if (this.connectionManager instanceof LazyEnlistableConnectionManager) {
                con.setLazyEnlistableConnectionManager((LazyEnlistableConnectionManager)this.connectionManager);
            }
        }
    }

    public void markConnectionAsBad(Connection connection) {
        if (connection instanceof ConnectionHolder) {
            ConnectionHolder userConnection = (ConnectionHolder)connection;
            userConnection.getManagedConnection().markForRemoval(true);
        }
    }
}

