/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import com.sun.enterprise.util.OS;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.common.ClassPathUtils;

public class CLIBootstrap {
    public static final String FILE_OPTIONS_INTRODUCER = "argsfile=";
    private static final String COMMA_IN_ARG_PLACEHOLDER = "+-+-+-+";
    private static final boolean isDebug = System.getenv("AS_DEBUG") != null;
    private static final String INPUT_ARGS = System.getenv("inputArgs");
    static final String ENV_VAR_PROP_PREFIX = "acc.";
    private static final String INSTALL_ROOT_PROPERTY_EXPR = "-Dcom.sun.aas.installRoot=";
    private static final String SECURITY_POLICY_PROPERTY_EXPR = "-Djava.security.policy=";
    private static final String SECURITY_AUTH_LOGIN_CONFIG_PROPERTY_EXPR = "-Djava.security.auth.login.config=";
    private static final String SYSTEM_CLASS_LOADER_PROPERTY_EXPR = "-Djava.system.class.loader=org.glassfish.appclient.client.acc.agent.ACCAgentClassLoader";
    private static final String[] ENV_VARS = new String[]{"_AS_INSTALL", "APPCPATH", "VMARGS"};
    private JavaInfo java = new JavaInfo();
    private GlassFishInfo gfInfo = new GlassFishInfo();
    private final JVMMainOption jvmMainSetting = new JVMMainOption();
    private final UserVMArgs userVMArgs = new UserVMArgs(System.getProperty("acc.VMARGS"));
    private final CommandLineElement accValuedOptions = new ACCValuedOption("-mainclass|-name|-xml|-configxml|-user|-password|-passwordfile|-targetserver");
    private final CommandLineElement accUnvaluedOptions = new ACCUnvaluedOption("-textauth|-noappinvoke|-usage|-help");
    private final CommandLineElement jvmValuedOptions;
    private final CommandLineElement jvmPropertySettings;
    private final CommandLineElement otherJVMOptions;
    private final CommandLineElement arguments;
    private final CommandLineElement[] elementsInScanOrder;
    private final CommandLineElement[] elementsInOutputOrder;
    private final AgentArgs agentArgs;

    public static void main(String[] args) {
        try {
            CLIBootstrap.envToProps();
            CLIBootstrap boot = new CLIBootstrap();
            if (INPUT_ARGS != null) {
                args = CLIBootstrap.convertInputArgsVariable(INPUT_ARGS);
            }
            String outputCommandLine = boot.run(args);
            if (isDebug) {
                System.err.println(outputCommandLine);
            }
            System.out.print(outputCommandLine);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UserError ue) {
            ue.displayAndExit();
        }
    }

    private static void envToProps() {
        for (String envVar : ENV_VARS) {
            String value = System.getenv(envVar);
            if (value == null) continue;
            System.setProperty(ENV_VAR_PROP_PREFIX + envVar, value);
            if (!isDebug) continue;
            System.err.println(ENV_VAR_PROP_PREFIX + envVar + " set to " + value);
        }
    }

    private static String[] convertInputArgsVariable(String inputArgs) {
        String escapedDoubleQuoteRegex = "?:(?<!\\\\)(?:(?:\\\\\\\\)*\\\\)\"";
        Pattern argPattern = Pattern.compile("\"((?:(?<!\\\\)(?:(?:\\\\\\\\)*\\\\)\"|[^\"])*)\"|((?:(?<!\\\\)(?:(?:\\\\\\\\)*\\\\)\"|[^\"\\s])+)");
        Matcher matcher = argPattern.matcher(inputArgs);
        ArrayList<String> argList = new ArrayList<String>();
        while (matcher.find()) {
            String arg = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            argList.add(arg);
            if (!isDebug) continue;
            System.err.println("Captured argument " + arg);
        }
        return argList.toArray(new String[argList.size()]);
    }

    CLIBootstrap() throws UserError {
        this.jvmValuedOptions = new JVMValuedOption("-classpath|-cp", this.userVMArgs.evJVMValuedOptions);
        this.jvmPropertySettings = new JVMOption("-D.*", this.userVMArgs.evJVMPropertySettings);
        this.otherJVMOptions = new JVMOption("-.*", this.userVMArgs.evOtherJVMOptions);
        this.arguments = new CommandLineArgument(".*", 32);
        this.elementsInScanOrder = new CommandLineElement[]{this.accValuedOptions, this.accUnvaluedOptions, this.jvmValuedOptions, this.jvmPropertySettings, this.jvmMainSetting, this.otherJVMOptions, this.arguments};
        this.elementsInOutputOrder = new CommandLineElement[]{this.jvmValuedOptions, this.jvmPropertySettings, this.otherJVMOptions, this.jvmMainSetting, this.arguments};
        this.agentArgs = new AgentArgs();
    }

    JavaInfo initJava() {
        return new JavaInfo();
    }

    private String run(String[] args) throws UserError {
        this.java = new JavaInfo();
        this.gfInfo = new GlassFishInfo();
        String[] augmentedArgs = new String[args.length + 2];
        augmentedArgs[0] = "-configxml";
        augmentedArgs[1] = this.gfInfo.configxml().getAbsolutePath();
        System.arraycopy(args, 0, augmentedArgs, 2, args.length);
        int i = 0;
        while (i < augmentedArgs.length) {
            boolean isMatched = false;
            for (CommandLineElement cle : this.elementsInScanOrder) {
                isMatched = cle.matches(augmentedArgs[i]);
                if (!isMatched) continue;
                i = cle.processValue(augmentedArgs, i);
                break;
            }
            if (isMatched) continue;
            throw new UserError("arg " + i + " = " + augmentedArgs[i] + " not recognized");
        }
        StringBuilder command = new StringBuilder(CLIBootstrap.quote(this.java.javaExe));
        this.addProperties(command);
        this.addAgentOption();
        if (!(this.jvmMainSetting.isSet() || this.isHelp() || this.isUsage())) {
            this.accUnvaluedOptions.processValue(new String[]{"-usage"}, 0);
        }
        boolean needSep = true;
        for (CommandLineElement e : this.elementsInOutputOrder) {
            needSep = this.processCommandElement(command, e, needSep);
        }
        return command.toString();
    }

    private void addProperties(StringBuilder command) {
        command.append(' ').append("-Dorg.glassfish.gmbal.no.multipleUpperBoundsException=true");
        command.append(' ').append("--add-opens=java.base/java.lang=ALL-UNNAMED");
        command.append(' ').append(INSTALL_ROOT_PROPERTY_EXPR).append(CLIBootstrap.quote(this.gfInfo.home().getAbsolutePath()));
        command.append(' ').append(SECURITY_POLICY_PROPERTY_EXPR).append(CLIBootstrap.quote(this.gfInfo.securityPolicy().getAbsolutePath()));
        command.append(' ').append(SYSTEM_CLASS_LOADER_PROPERTY_EXPR);
        command.append(' ').append("-Xshare:off");
        command.append(' ').append(SECURITY_AUTH_LOGIN_CONFIG_PROPERTY_EXPR).append(CLIBootstrap.quote(this.gfInfo.loginConfig().getAbsolutePath()));
    }

    private void addAgentOption() throws UserError {
        this.otherJVMOptions.processValue(new String[]{"-javaagent:" + CLIBootstrap.quote(this.gfInfo.agentJarPath()) + this.agentOptionsFromFile()}, 0);
    }

    private boolean processCommandElement(StringBuilder command, CommandLineElement commandLineElement, boolean needSep) {
        if (needSep) {
            command.append(' ');
        }
        return commandLineElement.format(command);
    }

    private static String quote(String string) {
        if (string.length() > 2 && string.charAt(0) != '\"' && string.charAt(string.length() - 1) != '\"') {
            return "\"" + string + "\"";
        }
        return string;
    }

    private static String quoteSuppressTokenSubst(String string) {
        return OS.isWindows() ? CLIBootstrap.quote(string) : CLIBootstrap.quote(string.replace("$", "\\$"));
    }

    static String quoteEscapedArgument(String string) {
        if (!OS.isWindows()) {
            string = string.replace("\\", "\\\\").replace("\"", "\\\"").replace("$", "\\$").replace("`", "\\`");
        }
        return "\"" + string + "\"";
    }

    public static String encodeArg(String string) {
        return string.replace(",", COMMA_IN_ARG_PLACEHOLDER);
    }

    public static String decodeArg(String string) {
        return string.replace(COMMA_IN_ARG_PLACEHOLDER, ",");
    }

    private boolean isHelp() {
        return this.accUnvaluedOptions.values.contains("-help");
    }

    private boolean isUsage() {
        return this.accUnvaluedOptions.values.contains("-usage");
    }

    private String agentOptionsFromFile() {
        try {
            return "=argsfile=" + CLIBootstrap.quote(this.fileContainingAgentArgs().getAbsolutePath());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private File fileContainingAgentArgs() throws IOException {
        File argsFile = File.createTempFile("acc", ".dat");
        PrintStream ps = new PrintStream(argsFile);
        ps.println(this.agentArgs.toString());
        ps.close();
        return argsFile;
    }

    class UserVMArgs {
        private CommandLineElement evJVMPropertySettings;
        private CommandLineElement evJVMValuedOptions;
        private CommandLineElement evOtherJVMOptions;
        private final List<CommandLineElement> evElements = new ArrayList<CommandLineElement>();

        UserVMArgs(String vmargs) throws UserError {
            if (isDebug) {
                System.err.println("VMARGS = " + (vmargs == null ? "null" : vmargs));
            }
            this.evJVMPropertySettings = new JVMOption("-D.*", null);
            this.evJVMValuedOptions = new JVMValuedOption("-classpath|-cp", null);
            this.evOtherJVMOptions = new JVMOption("-.*", null);
            this.initEVCommandLineElements();
            if (vmargs == null) {
                return;
            }
            this.processEVCommandLineElements(CLIBootstrap.convertInputArgsVariable(vmargs));
        }

        private void initEVCommandLineElements() {
            this.evElements.add(this.evJVMPropertySettings);
            this.evElements.add(this.evJVMValuedOptions);
            this.evElements.add(this.evOtherJVMOptions);
        }

        private void processEVCommandLineElements(String[] envVarJVMArgs) throws UserError {
            int i = 0;
            while (i < envVarJVMArgs.length) {
                boolean isMatched = false;
                for (CommandLineElement cle : this.evElements) {
                    isMatched = cle.matches(envVarJVMArgs[i]);
                    if (!isMatched) continue;
                    i = cle.processValue(envVarJVMArgs, i);
                    break;
                }
                if (isMatched) continue;
                throw new UserError("arg " + i + " = " + envVarJVMArgs[i] + " not recognized");
            }
        }
    }

    static class JavaInfo {
        private static final String SHELL_PROP_NAME = "org.glassfish.appclient.shell";
        private static final String ACCJava_ENV_VAR_NAME = "ACCJava";
        private final boolean useWindowsSyntax = File.separatorChar == '\\' && System.getProperty("org.glassfish.appclient.shell") == null;
        protected String javaExe;
        protected File jreHome;

        private JavaInfo() {
            this.init();
        }

        private void init() {
            this.jreHome = new File(System.getProperty("java.home"));
            this.javaExe = this.javaExe();
        }

        protected boolean isValid() {
            return this.javaExe != null && new File(this.javaExe).canExecute();
        }

        protected File javaBinDir() {
            return new File(this.jreHome, "bin");
        }

        String javaExe() {
            return System.getenv(ACCJava_ENV_VAR_NAME);
        }

        File endorsed() {
            return new File(this.lib(), "endorsed");
        }

        File ext() {
            return new File(this.lib(), "ext");
        }

        File lib() {
            return new File(this.jreHome, "lib");
        }

        String pathSeparator() {
            return this.useWindowsSyntax ? ";" : ":";
        }
    }

    static class GlassFishInfo {
        private final File home;
        private final File modules;
        private final File lib;
        private final File libAppclient;
        private static final String ACC_CONFIG_PREFIX = "domains/domain1/config";

        GlassFishInfo() {
            String asInstallPath = System.getProperty("acc._AS_INSTALL");
            if (asInstallPath == null || asInstallPath.length() == 0) {
                throw new IllegalArgumentException("_AS_INSTALL == null");
            }
            this.home = new File(asInstallPath);
            this.modules = new File(this.home, "modules");
            this.lib = new File(this.home, "lib");
            this.libAppclient = new File(this.lib, "appclient");
        }

        File home() {
            return this.home;
        }

        File modules() {
            return this.modules;
        }

        File lib() {
            return this.lib;
        }

        File configxml() {
            File configXMLFile = new File(new File(this.home, ACC_CONFIG_PREFIX), "glassfish-acc.xml");
            if (configXMLFile.canRead()) {
                return configXMLFile;
            }
            File sunACCXMLFile = new File(new File(this.home, ACC_CONFIG_PREFIX), "sun-acc.xml");
            if (sunACCXMLFile.canRead()) {
                return sunACCXMLFile;
            }
            return configXMLFile;
        }

        String[] endorsedPaths() {
            return new String[]{new File(this.lib, "endorsed").getAbsolutePath(), new File(this.modules, "endorsed").getAbsolutePath()};
        }

        String extPaths() {
            return new File(this.lib, "ext").getAbsolutePath();
        }

        String agentJarPath() {
            return new File(this.lib, "gf-client.jar").getAbsolutePath();
        }

        File securityPolicy() {
            return new File(this.libAppclient, "client.policy");
        }

        File loginConfig() {
            return new File(this.libAppclient, "appclientlogin.conf");
        }
    }

    private class JVMMainOption
    extends CommandLineElement {
        private static final String JVM_MAIN_PATTERN = "-jar|-client|[^-][^\\s]*";
        private String introducer;

        JVMMainOption() {
            super(JVM_MAIN_PATTERN);
            this.introducer = null;
        }

        boolean isJarSetting() {
            return "-jar".equals(this.introducer);
        }

        boolean isClientSetting() {
            return "-client".equals(this.introducer);
        }

        boolean isSet() {
            return !this.values.isEmpty();
        }

        @Override
        boolean matches(String element) {
            return (!this.isSet() || this.isClientSetting() && element.equals("-client")) && super.matches(element);
        }

        @Override
        int processValue(String[] args, int slot) throws UserError {
            this.values.clear();
            if (args[slot].charAt(0) != '-') {
                int result = super.processValue(args, slot);
                CLIBootstrap.this.agentArgs.add("client=class=" + (String)this.values.get(this.values.size() - 1));
                return result;
            }
            if (!this.nextLooksOK(args, slot)) {
                throw new UserError("-jar or -client requires value but missing");
            }
            this.introducer = args[slot++];
            int result = super.processValue(args, slot);
            String clientJarPath = (String)this.values.get(this.values.size() - 1);
            File clientJarFile = new File(clientJarPath);
            if (clientJarFile.isDirectory()) {
                CLIBootstrap.this.agentArgs.add("client=dir=" + CLIBootstrap.quote(clientJarFile.getAbsolutePath()));
                this.introducer = "-jar";
                this.values.set(this.values.size() - 1, CLIBootstrap.this.gfInfo.agentJarPath());
            } else {
                CLIBootstrap.this.agentArgs.add("client=jar=" + CLIBootstrap.quote(clientJarPath));
                if (clientJarPath.endsWith(".ear")) {
                    this.introducer = "-jar";
                    this.values.set(this.values.size() - 1, CLIBootstrap.this.gfInfo.agentJarPath());
                } else if (clientJarPath.endsWith(".jar")) {
                    this.introducer = null;
                    this.values.set(this.values.size() - 1, "-classpath");
                    this.values.add(CLIBootstrap.this.gfInfo.agentJarPath() + File.pathSeparatorChar + this.getClassPathForGfClient(clientJarPath));
                    this.values.add(ClassPathUtils.getMainClass(clientJarFile));
                }
            }
            return result;
        }

        private String getClassPathForGfClient(String clientJarPath) {
            URL[] classpath = ClassPathUtils.getJavaClassPathForAppClient();
            if (classpath.length == 0) {
                return clientJarPath;
            }
            return clientJarPath + File.pathSeparator + Stream.of(classpath).map(ClassPathUtils::convertToString).collect(Collectors.joining(File.pathSeparator));
        }

        @Override
        boolean format(StringBuilder commandLine) {
            if (this.introducer != null) {
                super.format(commandLine, false, "-jar");
                return super.format(commandLine, true);
            }
            return super.format(commandLine, false);
        }

        private boolean nextLooksOK(String[] args, int slot) {
            return this.isNextArg(args, slot) && args[slot + 1].charAt(0) != '-';
        }
    }

    private class JVMOption
    extends Option {
        JVMOption(String patternString, CommandLineElement vmargsJVMOptionElement) {
            super(patternString);
            if (vmargsJVMOptionElement != null) {
                this.values.addAll(vmargsJVMOptionElement.values);
            }
        }

        @Override
        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isSet() && super.matches(element);
        }
    }

    private class JVMValuedOption
    extends ValuedOption {
        JVMValuedOption(String patternString, CommandLineElement vmargsJVMValuedOption) {
            super(patternString);
            if (vmargsJVMValuedOption != null) {
                this.values.addAll(vmargsJVMValuedOption.values);
            }
        }

        @Override
        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isJarSetting() && super.matches(element);
        }
    }

    private class ACCUnvaluedOption
    extends Option {
        ACCUnvaluedOption(String patternString) {
            super(patternString);
        }

        @Override
        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isJarSetting() && super.matches(element);
        }

        @Override
        int processValue(String[] args, int slot) throws UserError {
            int result = super.processValue(args, slot);
            CLIBootstrap.this.agentArgs.addACCArg((String)this.values.get(this.values.size() - 1));
            return result;
        }

        @Override
        boolean format(StringBuilder commandLine) {
            return false;
        }
    }

    private class ACCValuedOption
    extends ValuedOption {
        ACCValuedOption(String patternString) {
            super(patternString);
        }

        @Override
        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isJarSetting() && super.matches(element);
        }

        @Override
        int processValue(String[] args, int slot) throws UserError {
            int result = super.processValue(args, slot);
            ValuedOption.OptionValue newOptionValue = (ValuedOption.OptionValue)this.optValues.get(this.optValues.size() - 1);
            CLIBootstrap.this.agentArgs.addACCArg(newOptionValue.option);
            CLIBootstrap.this.agentArgs.addACCArg(CLIBootstrap.quote(newOptionValue.value));
            return result;
        }

        @Override
        boolean format(StringBuilder commandLine) {
            return false;
        }
    }

    private class ValuedOption
    extends Option {
        List<OptionValue> optValues;

        ValuedOption(String patternString) {
            super(patternString);
            this.optValues = new ArrayList<OptionValue>();
        }

        @Override
        int processValue(String[] args, int slot) throws UserError {
            this.ensureNonOptionNextArg(args, slot);
            this.optValues.add(new OptionValue(args[slot++], args[slot++]));
            return slot;
        }

        @Override
        boolean format(StringBuilder commandLine) {
            for (OptionValue ov : this.optValues) {
                this.format(commandLine, false, ov.option);
                this.format(commandLine, true, ov.value);
            }
            return !this.optValues.isEmpty();
        }

        class OptionValue {
            private final String option;
            private final String value;

            OptionValue(String option, String value) {
                this.option = option;
                this.value = value;
            }
        }
    }

    private class Option
    extends CommandLineElement {
        Option(String patternString) {
            super(patternString);
        }
    }

    class CommandLineArgument
    extends CommandLineElement {
        CommandLineArgument(String patternString, int flags) {
            super(patternString, flags);
        }

        @Override
        StringBuilder format(StringBuilder commandLine, boolean useQuotes, String nextArg) {
            if (commandLine.length() > 0) {
                commandLine.append(' ');
            }
            commandLine.append(useQuotes ? CLIBootstrap.quoteEscapedArgument(nextArg) : nextArg);
            return commandLine;
        }
    }

    private class CommandLineElement {
        private final Pattern pattern;
        Matcher matcher;
        private final Pattern whiteSpacePattern = Pattern.compile("[\\r\\n]");
        final List<String> values = new ArrayList<String>();

        CommandLineElement(String patternString) {
            this(patternString, 0);
        }

        CommandLineElement(String patternString, int flags) {
            this.pattern = Pattern.compile(patternString, flags);
        }

        final boolean matchesPattern(String element) {
            this.matcher = this.pattern.matcher(element);
            return this.matcher.matches();
        }

        boolean matches(String element) {
            return this.matchesPattern(element);
        }

        int processValue(String[] args, int slot) throws UserError {
            Matcher matcher = this.whiteSpacePattern.matcher(args[slot]);
            if (!matcher.matches()) {
                this.values.add(args[slot++]);
            } else {
                ++slot;
            }
            return slot;
        }

        boolean isNextArg(String[] args, int currentSlot) {
            return currentSlot < args.length - 1;
        }

        void ensureNonOptionNextArg(String[] args, int currentSlot) throws UserError {
            if (currentSlot >= args.length - 1 || args[currentSlot + 1].charAt(0) == '-') {
                throw new UserError("Command line element " + args[currentSlot] + " requires non-option value");
            }
        }

        boolean format(StringBuilder commandLine) {
            return this.format(commandLine, true);
        }

        boolean format(StringBuilder commandLine, boolean useQuotes) {
            boolean needSep = false;
            for (String value : this.values) {
                if (needSep) {
                    commandLine.append(this.valueSep());
                }
                this.format(commandLine, useQuotes, value);
                needSep = true;
            }
            return !this.values.isEmpty();
        }

        char valueSep() {
            return ' ';
        }

        StringBuilder format(StringBuilder commandLine, boolean useQuotes, String v) {
            if (commandLine.length() > 0) {
                commandLine.append(' ');
            }
            commandLine.append(useQuotes ? CLIBootstrap.quoteSuppressTokenSubst(v) : v);
            return commandLine;
        }
    }

    private static class AgentArgs {
        private final StringBuilder args = new StringBuilder("=mode=acscript");
        private final char sep = (char)44;

        AgentArgs() {
            String appcPath = System.getProperty("acc.APPCPATH");
            if (appcPath != null && appcPath.length() > 0) {
                this.add("appcpath=" + CLIBootstrap.quote(appcPath));
            }
        }

        final void add(String item) {
            this.args.append(',').append(item);
        }

        final void addACCArg(String accArg) {
            this.add("arg=" + CLIBootstrap.encodeArg(accArg));
        }

        public String toString() {
            return this.args.toString();
        }
    }
}

