/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.audit.BaseAuditManager;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.login.Configuration;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class SecurityConfigListener
implements ConfigListener,
PostConstruct {
    @Inject
    @Named(value="default-instance-name")
    SecurityService securityService;
    @Inject
    private Logger logger;
    @Inject
    private RealmsManager realmsManager;
    @Inject
    BaseAuditManager auditManager;
    private String auditEnabled = null;
    private String defaultRealm = null;
    private String jacc = null;
    private String activateDefaultP2RMapping = null;
    private String mappedPrincipalClassName = null;

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                NotProcessed np = null;
                switch (type) {
                    case ADD: {
                        SecurityConfigListener.this.logger.fine("A new " + changedType.getName() + " was added : " + changedInstance);
                        np = this.handleAddEvent(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        SecurityConfigListener.this.logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                        np = this.handleChangeEvent(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        SecurityConfigListener.this.logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                        np = this.handleRemoveEvent(changedInstance);
                    }
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
                NotProcessed np = null;
                if (instance instanceof AuthRealm) {
                    SecurityConfigListener.authRealmCreated((AuthRealm)instance);
                } else if (instance instanceof JaccProvider) {
                    np = new NotProcessed("Cannot change JACC provider once installed, restart required");
                } else if (instance instanceof AuditModule) {
                    SecurityConfigListener.this.auditModuleCreated((AuditModule)instance);
                } else if (!(instance instanceof MessageSecurityConfig) && !(instance instanceof SecurityService)) {
                    np = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
                NotProcessed np = null;
                if (instance instanceof AuthRealm) {
                    SecurityConfigListener.authRealmDeleted((AuthRealm)instance);
                } else if (instance instanceof JaccProvider) {
                    np = new NotProcessed("Cannot change JACC provider once installed, restart required");
                } else if (instance instanceof AuditModule) {
                    SecurityConfigListener.this.auditModuleDeleted((AuditModule)instance);
                } else if (!(instance instanceof MessageSecurityConfig) && !(instance instanceof SecurityService)) {
                    np = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
                NotProcessed np = null;
                if (instance instanceof AuthRealm) {
                    SecurityConfigListener.this.authRealmUpdated((AuthRealm)instance);
                } else if (instance instanceof JaccProvider) {
                    np = new NotProcessed("Cannot change JACC provider once installed, restart required");
                } else if (instance instanceof AuditModule) {
                    SecurityConfigListener.this.auditModuleUpdated((AuditModule)instance);
                } else if (!(instance instanceof MessageSecurityConfig)) {
                    if (instance instanceof SecurityService) {
                        if (SecurityConfigListener.this.defaultRealm != null && !SecurityConfigListener.this.defaultRealm.equals(((SecurityService)instance).getDefaultRealm())) {
                            SecurityConfigListener.this.defaultRealm = ((SecurityService)instance).getDefaultRealm();
                            Realm.setDefaultRealm(SecurityConfigListener.this.defaultRealm);
                        }
                        if (SecurityConfigListener.this.auditEnabled != null && !SecurityConfigListener.this.auditEnabled.equals(((SecurityService)instance).getAuditEnabled())) {
                            boolean auditON = Boolean.parseBoolean(((SecurityService)instance).getAuditEnabled());
                            SecurityConfigListener.this.auditManager.setAuditOn(auditON);
                        }
                        if (!SecurityConfigListener.this.jacc.equals(((SecurityService)instance).getJacc())) {
                            np = new NotProcessed("Cannot change JACC provider once installed, restart required");
                        }
                        if (SecurityConfigListener.this.mappedPrincipalClassName != null && !SecurityConfigListener.this.mappedPrincipalClassName.equals(((SecurityService)instance).getMappedPrincipalClass())) {
                            np = new NotProcessed("MappedPrincipalClassname changes for existing applications requires restart and redeployment");
                        }
                        if (!SecurityConfigListener.this.activateDefaultP2RMapping.equals(((SecurityService)instance).getActivateDefaultPrincipalToRoleMapping())) {
                            np = new NotProcessed("DefaultP2R changes for existng applications requires restart and redeployment");
                        }
                    } else {
                        np = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
                    }
                }
                return np;
            }
        }, (Logger)this.logger);
        return null;
    }

    public static void authRealmCreated(AuthRealm instance) {
        try {
            SecurityConfigListener.createRealm(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void authRealmCreated(Config config, AuthRealm instance) {
        try {
            SecurityConfigListener.createRealm(config, instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void authRealmDeleted(Config config, AuthRealm instance) {
        try {
            if (!Realm.isValidRealm(config.getName(), instance.getName())) {
                return;
            }
            Realm.unloadInstance(config.getName(), instance.getName());
        }
        catch (NoSuchRealmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void authRealmDeleted(AuthRealm instance) {
        try {
            if (!Realm.isValidRealm(instance.getName())) {
                return;
            }
            Realm.unloadInstance(instance.getName());
        }
        catch (NoSuchRealmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void authRealmUpdated(AuthRealm instance) {
        try {
            this.realmsManager.removeFromLoadedRealms(instance.getName());
            SecurityConfigListener.createRealm(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void authRealmUpdated(Config config, AuthRealm instance) {
        try {
            this.realmsManager.removeFromLoadedRealms(config.getName(), instance.getName());
            SecurityConfigListener.createRealm(config, instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void createRealm(AuthRealm authRealm) throws Exception {
        String className = authRealm.getClassname();
        List elementProps = authRealm.getProperty();
        Properties props = new Properties();
        if (elementProps != null) {
            for (Property p : elementProps) {
                props.setProperty(p.getName(), p.getValue());
            }
        }
        Realm.instantiate(authRealm.getName(), className, props);
        Configuration.getConfiguration().refresh();
    }

    private static void createRealm(Config config, AuthRealm authRealm) throws Exception {
        String className = authRealm.getClassname();
        List elementProps = authRealm.getProperty();
        Properties props = new Properties();
        if (elementProps != null) {
            for (Property p : elementProps) {
                props.setProperty(p.getName(), p.getValue());
            }
        }
        Realm.instantiate(authRealm.getName(), className, props, config.getName());
        Configuration.getConfiguration().refresh();
    }

    public void postConstruct() {
        if (this.securityService == null) {
            return;
        }
        this.auditEnabled = this.securityService.getAuditEnabled();
        this.defaultRealm = this.securityService.getDefaultRealm();
        this.jacc = this.securityService.getJacc();
        if (this.jacc == null) {
            this.jacc = "default";
        }
        this.activateDefaultP2RMapping = this.securityService.getActivateDefaultPrincipalToRoleMapping();
        this.mappedPrincipalClassName = this.securityService.getMappedPrincipalClass();
    }

    public void auditModuleCreated(AuditModule instance) {
        try {
            String classname = instance.getClassname();
            List props = instance.getProperty();
            Properties properties = new Properties();
            if (props != null) {
                for (Property p : props) {
                    properties.put(p.getName(), p.getValue());
                }
            }
            this.auditManager.addAuditModule(instance.getName(), classname, properties);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void auditModuleDeleted(AuditModule instance) {
        this.auditManager.removeAuditModule(instance.getName());
    }

    public void auditModuleUpdated(AuditModule instance) {
        try {
            List props = instance.getProperty();
            Properties properties = new Properties();
            if (props != null) {
                for (Property p : props) {
                    properties.put(p.getName(), p.getValue());
                }
            }
            this.auditManager.addAuditModule(instance.getName(), instance.getClassname(), properties);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

