/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io.txnlog.file;

import com.sun.messaging.jmq.io.txnlog.CheckPointListener;
import com.sun.messaging.jmq.io.txnlog.TransactionLogRecord;
import com.sun.messaging.jmq.io.txnlog.TransactionLogWriter;
import com.sun.messaging.jmq.io.txnlog.file.FileCorruptedException;
import com.sun.messaging.jmq.io.txnlog.file.FileLogRecordIterator;
import com.sun.messaging.jmq.io.txnlog.file.FileTransactionLogRecord;
import com.sun.messaging.jmq.util.MQThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FileTransactionLogWriter
implements TransactionLogWriter,
Runnable {
    public static final short FILE_VERSION = 1;
    public static final int FILE_HEADER_SIZE = 48;
    public static final int FILE_MAGIC_NUMBER = 0x5555AAAA;
    public static final short FILE_RESERVED_SHORT = 0;
    public static final int FILE_STATUS_POSITION = 6;
    public static final int FILE_CHECK_POINT_POSITION = 8;
    public static final int FILE_CHECK_SUM_POSITION = 32;
    public static final int RECORD_HEADER_SIZE = 48;
    public static final int RECORD_MAGIC_NUMBER = -1431677611;
    public static final int RECORD_TYPE = -1;
    public static final long RECORD_TIME_STAMP = 0L;
    public static final int RECORD_BODY_SIZE = 0;
    public static final long RECORD_CHECK_SUM = 0L;
    public static final int RECORD_HEADER_RESERVE = 0;
    public static final short FILE_STATUS_CREATE_NORMAL = 0;
    public static final short FILE_STATUS_SHUTDOWN_NORMAL = 1;
    public static final short FILE_STATUS_BACKUP = 2;
    public static final short FILE_STATUS_CHK_POINT_UPDATED = 3;
    public static final short FILE_STATUS_RESET = 4;
    public static final long DEFAULT_MAX_SIZE_KB = 10240L;
    public static final String TXNLOG_DEBUG_PROP_NAME = "imq.txnlog.debug";
    public static final String TXNLOG_BACKUP_PROP_NAME = "imq.txnlog.backup";
    private long maxSize = 0xA00000L;
    private long cpOffset = 512000L;
    private long cpSize = this.maxSize - this.cpOffset;
    private CheckPointListener callback = null;
    private boolean isListenerCalled = false;
    private RandomAccessFile raf = null;
    private File file = null;
    public static final String RWD_MODE = "rwd";
    private static final String RWS_MODE = "rws";
    public static final String RW_MODE = "rw";
    private String fileMode = "rwd";
    private FileChannel fchannel = null;
    private boolean useFileChannelSync = false;
    private long checkPointPosition = 48L;
    private boolean debug = false;
    private Object txnLogSyncObj = new Object();
    private Checksum checksumEngine = new Adler32();
    private boolean playBackRequired = false;
    private boolean isFileCorrupted = false;
    private long checkpointSequence = 0L;
    private long entrySequence = 0L;
    private TransactionLogRecord lastEntry = null;
    public static final String TXNLOG_BACKUP_EXT = ".1";
    private boolean doFileBackup = false;
    private boolean doAsyncWrites = false;
    private boolean closed;
    private MQThread asyncWriteThread = null;
    private boolean synch = true;
    private int sampleNum;
    private int sampleCount = 1000;
    private int[] numrecordsArray = new int[this.sampleCount];
    private long currentAppCookie = 0L;
    private long existingAppCookie = 0L;
    private List<TransactionLogRecord> transactionLogRecordList = new LinkedList<TransactionLogRecord>();
    private Object recordListMutex = new Object();

    public FileTransactionLogWriter(File parent, String fileName, long size) throws IOException {
        this.init(parent, fileName, size);
    }

    public FileTransactionLogWriter(String fileName) throws IOException {
        this.init(null, fileName, 0xA00000L);
    }

    public FileTransactionLogWriter(File parent, String fileName, long size, String mode, long applicationCookie) throws IOException {
        this(parent, fileName, size, mode, true, false, applicationCookie);
    }

    public FileTransactionLogWriter(File parent, String fileName, long size, String mode, boolean sync, boolean groupCommit, long applicationCookie) throws IOException {
        if (RW_MODE.equals(mode)) {
            this.useFileChannelSync = true;
            this.fileMode = RW_MODE;
        } else if (RWS_MODE.equals(mode)) {
            this.fileMode = RWS_MODE;
        } else if (!RWD_MODE.equals(mode)) {
            throw new IllegalArgumentException("This file mode is not supported: " + mode);
        }
        this.currentAppCookie = applicationCookie;
        this.synch = sync;
        this.doAsyncWrites = groupCommit;
        this.init(parent, fileName, size);
    }

    private void init(File parent, String child, long size) throws IOException {
        this.debug = Boolean.getBoolean(TXNLOG_DEBUG_PROP_NAME);
        this.doFileBackup = Boolean.getBoolean(TXNLOG_BACKUP_PROP_NAME);
        this.file = new File(parent, child);
        this.setMaximumSize(size);
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.doAsyncWrites) {
            this.log("starting asyncwrite");
            this.asyncWriteThread = new MQThread(this, child + "AsyncWrite");
            this.asyncWriteThread.setPriority(4);
            this.asyncWriteThread.start();
        }
        this.log("Using file mode: " + this.fileMode);
        this.raf = new RandomAccessFile(this.file, this.fileMode);
        if (this.useFileChannelSync) {
            this.log("File Channel Sync flag is on ...");
            this.fchannel = this.raf.getChannel();
        }
        if (this.raf.length() > 0L) {
            if (this.debug) {
                this.log("file exists: " + this.file.getAbsolutePath() + ", file size: " + this.raf.length());
            }
            this.readFileHeader();
            if (!this.playBackRequired) {
                this.writeFileHeader((short)3, 48L);
            }
        } else {
            this.existingAppCookie = this.currentAppCookie;
            this.initNewFile();
        }
    }

    private void initNewFile() throws IOException {
        this.raf.seek(0L);
        this.raf.setLength((int)this.maxSize);
        this.doWrite(new byte[(int)this.maxSize]);
        this.checkpointSequence = 0L;
        this.entrySequence = 0L;
        this.writeFileHeader((short)0, 48L);
        if (this.debug) {
            this.log("file created: " + this.file.getAbsolutePath() + ", size: " + this.raf.length());
        }
    }

    private void readFileHeader() throws IOException {
        this.raf.seek(0L);
        byte[] bytes = new byte[48];
        int size = this.raf.read(bytes);
        if (size != 48) {
            this.isFileCorrupted = true;
            throw new FileCorruptedException("File Header size mismatch. Expected:  48, read: " + size);
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int magic = buf.getInt();
        short fversion = buf.getShort();
        short shutdownState = buf.getShort();
        long cpPosition = buf.getLong();
        long timestamp = buf.getLong();
        long cpseq = buf.getLong();
        long chksum = buf.getLong();
        long fileCookie = buf.getLong();
        long calculated = this.calculateCheckSum(bytes, 0, 32);
        if (this.debug) {
            this.log("read file header, magic=" + magic + ", fversion=" + fversion + ", status=" + shutdownState + ", cpPosition=" + cpPosition + ", timestamp=" + timestamp + ", cpSequence=" + cpseq + ", chksum=" + chksum);
        }
        if (chksum != calculated) {
            this.isFileCorrupted = true;
            throw new FileCorruptedException("File Header checksum mismatch. Expected: " + chksum + ", calculated: " + calculated);
        }
        if (magic != 0x5555AAAA || fversion != 1) {
            this.isFileCorrupted = true;
            throw new FileCorruptedException("File Magic number/version mismatch: " + magic + ":" + fversion);
        }
        if (shutdownState != 1) {
            this.playBackRequired = true;
        }
        if (this.debug) {
            this.log("playbackRequired=" + this.playBackRequired);
        }
        this.checkPointPosition = cpPosition;
        this.checkpointSequence = cpseq;
        this.raf.seek(48L);
        this.existingAppCookie = fileCookie;
        if (this.existingAppCookie != this.currentAppCookie) {
            this.log("application cookies do not match! Existing file has version=" + this.existingAppCookie + " Current version of software=" + this.currentAppCookie);
        }
    }

    private void writeFileHeader(short fileStatus, long cpPosition) throws IOException {
        this.checkpointSequence = this.checkpointSequence > 0x7FFFFFFFFFFFFFFEL ? 0L : ++this.checkpointSequence;
        this.entrySequence = 0L;
        this.raf.seek(0L);
        byte[] bytes = new byte[48];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.putInt(0x5555AAAA);
        buf.putShort((short)1);
        buf.putShort(fileStatus);
        buf.putLong(cpPosition);
        long timestamp = System.currentTimeMillis();
        buf.putLong(timestamp);
        buf.putLong(this.checkpointSequence);
        long chksum = this.calculateCheckSum(bytes, 0, 32);
        buf.putLong(chksum);
        buf.putLong(this.existingAppCookie);
        this.doWrite(bytes);
        if (this.debug) {
            this.log("write file header. magic=1431677610, fversion=1, status=" + fileStatus + ", cpPosition=" + cpPosition + ", timestamp=" + timestamp + ", cpSequence=" + this.checkpointSequence + ", chksum=" + chksum);
        }
    }

    @Override
    public void setCheckpointSize(long bytes) {
        this.cpSize = bytes;
    }

    @Override
    public void setMaximumSize(long bytes) {
        this.maxSize = bytes;
        this.cpSize = this.maxSize - this.cpOffset;
        if (this.cpSize < 96L) {
            this.cpSize = 96L;
        }
    }

    @Override
    public void setCheckPointOffset(long offset) {
        this.cpOffset = offset;
        this.cpSize = this.maxSize - offset;
        if (this.cpSize < 96L) {
            this.cpSize = 96L;
        }
    }

    @Override
    public void setCheckPointListener(CheckPointListener cb) {
        this.callback = cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsyncRecord(TransactionLogRecord entry) throws IOException {
        Object object = this.recordListMutex;
        synchronized (object) {
            this.transactionLogRecordList.add(entry);
            this.recordListMutex.notifyAll();
        }
        object = entry;
        synchronized (object) {
            try {
                while (!entry.isWritten()) {
                    entry.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransactionLogRecordList() {
        TransactionLogRecord[] records = null;
        Object object = this.recordListMutex;
        synchronized (object) {
            while (this.transactionLogRecordList.size() == 0 && !this.closed) {
                try {
                    this.recordListMutex.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            records = new TransactionLogRecord[this.transactionLogRecordList.size()];
            records = this.transactionLogRecordList.toArray(records);
            this.transactionLogRecordList.clear();
        }
        if (this.debug) {
            this.numrecordsArray[this.sampleNum] = records.length;
            ++this.sampleNum;
            int totalCount = 0;
            if (this.sampleNum == this.sampleCount) {
                this.sampleNum = 0;
                for (int i = 0; i < this.sampleCount; ++i) {
                    totalCount += this.numrecordsArray[i];
                    System.out.print(this.numrecordsArray[i] + ",");
                }
                float averageCount = (float)totalCount / (float)this.sampleCount;
                this.log(" average records in compound txn record = " + averageCount);
            }
        }
        if (records.length == 1) {
            TransactionLogRecord entry = records[0];
            try {
                this.writeRecord(entry);
            }
            catch (IOException e) {
                entry.setException(e);
            }
            TransactionLogRecord e = entry;
            synchronized (e) {
                entry.setWritten(true);
                entry.notifyAll();
            }
            return;
        }
        try {
            this.writeCompoundRecord(records);
        }
        catch (IOException ioe) {
            for (int i = 0; i < records.length; ++i) {
                TransactionLogRecord e = records[i];
                e.setException(ioe);
            }
        }
        for (int i = 0; i < records.length; ++i) {
            TransactionLogRecord e;
            TransactionLogRecord transactionLogRecord = e = records[i];
            synchronized (transactionLogRecord) {
                e.setWritten(true);
                e.notifyAll();
                continue;
            }
        }
    }

    @Override
    public void run() {
        this.log("run called ");
        while (!this.closed) {
            try {
                this.processTransactionLogRecordList();
            }
            catch (Exception exception) {}
        }
        this.log("run ending ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCompoundRecord(TransactionLogRecord[] records) throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            int numRecords = records.length;
            FileTransactionLogRecord entry = new FileTransactionLogRecord();
            entry.setType(8);
            int compoundBodySize = 4;
            for (int i = 0; i < numRecords; ++i) {
                compoundBodySize += 8;
                compoundBodySize += records[i].getBody().length;
            }
            byte[] compoundBody = new byte[compoundBodySize];
            ByteBuffer subBuf = ByteBuffer.wrap(compoundBody);
            subBuf.putInt(numRecords);
            for (int i = 0; i < numRecords; ++i) {
                subBuf.putInt(records[i].getType());
                subBuf.putInt(records[i].getBody().length);
                subBuf.put(records[i].getBody());
            }
            entry.setBody(compoundBody);
            entry.setCheckPointSequence(this.checkpointSequence);
            entry.setTimestamp(System.currentTimeMillis());
            entry.setSequence(this.entrySequence++);
            int size = 48 + entry.getBody().length;
            byte[] bytes = new byte[size];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            this.writeRecordHeader(buf, entry);
            buf.put(entry.getBody());
            this.doWrite(bytes);
            if (this.raf.getFilePointer() > this.cpSize && !this.isListenerCalled) {
                if (this.debug) {
                    this.log("calling check point listener, fpointer: " + this.raf.getFilePointer());
                }
                this.callback.checkpoint();
                this.isListenerCalled = true;
            }
            this.lastEntry = entry;
        }
    }

    @Override
    public void write(TransactionLogRecord entry) throws IOException {
        if (this.doAsyncWrites) {
            this.writeAsyncRecord(entry);
        } else {
            this.writeRecord(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecord(TransactionLogRecord entry) throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.isFileCorrupted) {
                throw new IllegalStateException("File is corrupted. You must reset the log file to continue.");
            }
            if (this.playBackRequired) {
                throw new IllegalStateException("File not synced.  You must call Iterator to play back log file.");
            }
            if (this.callback == null) {
                throw new IllegalStateException("Check point listener not set. You must set a CheckPointListener before writing TransactionLogRecords.");
            }
            entry.setCheckPointSequence(this.checkpointSequence);
            entry.setTimestamp(System.currentTimeMillis());
            entry.setSequence(this.entrySequence++);
            int size = 48 + entry.getBody().length;
            byte[] bytes = new byte[size];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            this.writeRecordHeader(buf, entry);
            buf.put(entry.getBody());
            this.doWrite(bytes);
            if (this.raf.getFilePointer() > this.cpSize && !this.isListenerCalled) {
                if (this.debug) {
                    this.log("calling check point listener, fpointer: " + this.raf.getFilePointer());
                }
                this.callback.checkpoint();
                this.isListenerCalled = true;
            }
            this.lastEntry = entry;
        }
    }

    private void writeRecordHeader(ByteBuffer buf, TransactionLogRecord entry) {
        buf.putInt(-1431677611);
        buf.putInt(entry.getType());
        buf.putInt(entry.getBody().length);
        buf.putLong(entry.getTimestamp());
        buf.putLong(entry.getSequence());
        buf.putLong(entry.getCheckPointSequence());
        long value = this.calculateCheckSum(entry.getBody());
        buf.putLong(value);
        buf.putInt(0);
    }

    private void doWrite(byte[] bytes) throws IOException {
        this.raf.write(bytes);
        if (this.useFileChannelSync && this.synch) {
            this.raf.getFD().sync();
        }
    }

    long calculateCheckSum(byte[] body) {
        long value = this.calculateCheckSum(body, 0, body.length);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long calculateCheckSum(byte[] body, int offset, int length) {
        long value = -1L;
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            this.checksumEngine.update(body, offset, length);
            value = this.checksumEngine.getValue();
            this.checksumEngine.reset();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionLogRecord checkpoint() throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            long pos = this.raf.getFilePointer();
            if (pos > this.cpSize) {
                this.writeFileHeader((short)3, 48L);
            } else {
                this.writeFileHeader((short)3, pos);
                this.raf.seek(pos);
            }
            this.isListenerCalled = false;
            return this.lastEntry;
        }
    }

    @Override
    public Iterator iterator() throws IOException {
        FileLogRecordIterator it = new FileLogRecordIterator(this);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        this.log("Reseting txn log file ...");
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            if (this.doFileBackup) {
                this.backupLogFile();
            }
            if (this.isFileCorrupted) {
                this.initNewFile();
            } else {
                this.writeFileHeader((short)3, 48L);
            }
            this.checkPointPosition = 48L;
            this.playBackRequired = false;
            this.isFileCorrupted = false;
            this.isListenerCalled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionLogRecord getLastEntry() {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            return this.lastEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean clean) throws IOException {
        if (clean) {
            this.close();
            return;
        }
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            this.raf.close();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            this.raf.getFilePointer();
            this.writeFileHeader((short)1, 48L);
            this.raf.close();
            this.closed = true;
        }
    }

    @Override
    public TransactionLogRecord newTransactionLogRecord() {
        return new FileTransactionLogRecord();
    }

    RandomAccessFile getRAF() {
        return this.raf;
    }

    long getCPPosition() {
        return this.checkPointPosition;
    }

    public synchronized long getCPSequence() {
        return this.checkpointSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupLogFile() throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            String txnlogName = this.file.getCanonicalPath();
            this.deleteBackUpFile(txnlogName);
            this.copyFile(txnlogName);
        }
    }

    private void copyFile(String txnlogName) throws IOException {
        String bname = txnlogName + TXNLOG_BACKUP_EXT;
        File bfile = new File(bname);
        if (bfile.exists()) {
            throw new IOException("Cannot backup txnlog.  You must remove the back up file to continue: " + bname);
        }
        long savedPosition = this.raf.getFilePointer();
        if (!this.useFileChannelSync) {
            this.fchannel = this.raf.getChannel();
        }
        this.fchannel.position(0L);
        FileChannel fc2 = new FileOutputStream(bfile).getChannel();
        fc2.transferFrom(this.fchannel, 0L, this.fchannel.size());
        fc2.close();
        if (!this.useFileChannelSync) {
            this.fchannel.close();
            this.raf.close();
            this.raf = new RandomAccessFile(this.file, this.fileMode);
        }
        this.raf.seek(savedPosition);
    }

    private void deleteBackUpFile(String txnLogName) throws IOException {
        String backupName2 = txnLogName + TXNLOG_BACKUP_EXT;
        File bfile2 = new File(backupName2);
        if (bfile2.exists()) {
            bfile2.delete();
        }
    }

    @Override
    public boolean playBackRequired() {
        return this.playBackRequired;
    }

    private void log(String msg) {
        if (this.debug) {
            System.out.println(new Date() + " " + Thread.currentThread() + ": " + msg);
        }
    }

    public long getExistingAppCookie() {
        return this.existingAppCookie;
    }
}

