/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.SecurityService;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface AdminService
extends ConfigBeanProxy,
PropertyBag {
    @Attribute(defaultValue="server")
    @Pattern(regexp="(das|das-and-server|server)")
    public @Pattern(regexp="(das|das-and-server|server)") String getType();

    public void setType(String var1) throws PropertyVetoException;

    @Attribute
    public String getSystemJmxConnectorName();

    public void setSystemJmxConnectorName(String var1) throws PropertyVetoException;

    @Element(value="jmx-connector")
    public List<JmxConnector> getJmxConnector();

    @Element(value="das-config")
    @NotNull
    public DasConfig getDasConfig();

    public void setDasConfig(DasConfig var1) throws PropertyVetoException;

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Attribute(defaultValue="admin-realm")
    @NotNull
    public String getAuthRealmName();

    public void setAuthRealmName(String var1);

    @DuckTyped
    public JmxConnector getSystemJmxConnector();

    @DuckTyped
    public AuthRealm getAssociatedAuthRealm();

    @DuckTyped
    public boolean usesFileRealm();

    public static class Duck {
        public static JmxConnector getSystemJmxConnector(AdminService as) {
            List<JmxConnector> connectors = as.getJmxConnector();
            for (JmxConnector connector : connectors) {
                if (!as.getSystemJmxConnectorName().equals(connector.getName())) continue;
                return connector;
            }
            return null;
        }

        public static AuthRealm getAssociatedAuthRealm(AdminService as) {
            String rn = as.getAuthRealmName();
            Config cfg = (Config)as.getParent(Config.class);
            SecurityService ss = cfg.getSecurityService();
            List<AuthRealm> realms = ss.getAuthRealm();
            for (AuthRealm realm : realms) {
                if (!rn.equals(realm.getName())) continue;
                return realm;
            }
            return null;
        }

        public static boolean usesFileRealm(AdminService as) {
            boolean usesFR = false;
            AuthRealm ar = as.getAssociatedAuthRealm();
            if (ar != null && "com.sun.enterprise.security.auth.realm.file.FileRealm".equals(ar.getClassname())) {
                usesFR = true;
            }
            return usesFR;
        }
    }
}

