/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class MQJMXConnectorInfo {
    private String jmxServiceURL = null;
    private Map<String, ?> jmxConnectorEnv = null;
    private String asInstanceName = null;
    private String brokerInstanceName = null;
    private String brokerType = null;
    private static final Logger _logger = Logger.getLogger("jakarta.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MQJMXConnectorInfo.class);
    private JMXConnector connector = null;

    public MQJMXConnectorInfo(String asInstanceName, String brokerInstanceName, String brokerType, String jmxServiceURL, Map<String, ?> jmxConnectorEnv) {
        this.brokerInstanceName = brokerInstanceName;
        this.asInstanceName = asInstanceName;
        this.jmxServiceURL = jmxServiceURL;
        this.brokerType = brokerType;
        this.jmxConnectorEnv = jmxConnectorEnv;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "MQJMXConnectorInfo : brokerInstanceName " + brokerInstanceName + " ASInstanceName " + asInstanceName + " jmxServiceURL " + jmxServiceURL + " BrokerType " + brokerType + " jmxConnectorEnv " + jmxConnectorEnv);
        }
    }

    public String getBrokerInstanceName() {
        return this.brokerInstanceName;
    }

    public String getBrokerType() {
        return this.brokerType;
    }

    public String getASInstanceName() {
        return this.asInstanceName;
    }

    public String getJMXServiceURL() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "MQJMXConnectorInfo :: JMXServiceURL is " + this.jmxServiceURL);
        }
        return this.jmxServiceURL;
    }

    public Map<String, ?> getJMXConnectorEnv() {
        return this.jmxConnectorEnv;
    }

    public MBeanServerConnection getMQMBeanServerConnection() throws ConnectorRuntimeException {
        try {
            if (this.getJMXServiceURL() == null || this.getJMXServiceURL().equals("")) {
                String msg = localStrings.getLocalString("error.get.jmsserviceurl", "Failed to get MQ JMXServiceURL of {0}.", new Object[]{this.getASInstanceName()});
                throw new ConnectorRuntimeException(msg);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "creating MBeanServerConnection to MQ JMXServer with " + this.getJMXServiceURL());
            }
            JMXServiceURL jmxServiceURL = new JMXServiceURL(this.getJMXServiceURL());
            this.connector = JMXConnectorFactory.connect(jmxServiceURL, this.jmxConnectorEnv);
            MBeanServerConnection mbsc = this.connector.getMBeanServerConnection();
            return mbsc;
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
    }

    public void closeMQMBeanServerConnection() throws ConnectorRuntimeException {
        try {
            if (this.connector != null) {
                this.connector.close();
            }
        }
        catch (IOException e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
    }
}

