/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.XAParticipant;
import com.sun.messaging.bridge.service.jms.tx.log.BranchXidDecision;
import com.sun.messaging.bridge.service.jms.tx.log.GlobalXidDecision;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.transaction.xa.Xid;

public class LogRecord
implements Externalizable {
    private GlobalXidDecision _gxidd = null;
    private BranchXidDecision[] _bxidds = null;

    public LogRecord() {
    }

    public LogRecord(GlobalXid gxid, Collection<XAParticipant> parties, int decision) throws Exception {
        this._gxidd = new GlobalXidDecision(gxid, decision);
        this._bxidds = new BranchXidDecision[parties.size()];
        XAParticipant party = null;
        Iterator<XAParticipant> itr = parties.iterator();
        int i = 0;
        while (itr.hasNext()) {
            party = itr.next();
            this._bxidds[i] = new BranchXidDecision(party.getBranchXid(), decision);
            ++i;
        }
    }

    public GlobalXid getGlobalXid() {
        return this._gxidd.getGlobalXid();
    }

    public int getGlobalDecision() {
        return this._gxidd.getGlobalDecision();
    }

    public BranchXidDecision[] getBranchXidDecisions() {
        return this._bxidds;
    }

    public int getBranchCount() {
        return this._bxidds.length;
    }

    public void setBranchHeurCommit(BranchXid bxid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals((Xid)((Object)bxid))) continue;
            this._bxidds[i].setBranchDecision(50);
        }
        throw new NoSuchElementException("Branch " + bxid + " not found in " + this._gxidd);
    }

    public void setBranchHeurRollback(BranchXid bxid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals((Xid)((Object)bxid))) continue;
            this._bxidds[i].setBranchDecision(51);
        }
        throw new NoSuchElementException("Branch " + bxid + " not found in " + this._gxidd);
    }

    public void setBranchHeurMixed(BranchXid bxid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals((Xid)((Object)bxid))) continue;
            this._bxidds[i].setBranchDecision(52);
        }
        throw new NoSuchElementException("Branch " + bxid + " not found in " + this._gxidd);
    }

    public boolean isHeuristicBranch(BranchXid bxid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals((Xid)((Object)bxid))) continue;
            return this._bxidds[i].isHeuristic() || this._bxidds[i].getBranchDecision() != this._gxidd.getGlobalDecision();
        }
        throw new NoSuchElementException("Branch " + bxid + " not found in global transaction " + this._gxidd);
    }

    public int getBranchDecision(BranchXid bxid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals((Xid)((Object)bxid))) continue;
            return this._bxidds[i].getBranchDecision();
        }
        throw new NoSuchElementException("Branch " + bxid + " not found in " + this._gxidd);
    }

    public void setBranchDecision(BranchXid bxid, int d) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals((Xid)((Object)bxid))) continue;
            this._bxidds[i].setBranchDecision(d);
        }
        throw new NoSuchElementException("Branch " + bxid + " not found in " + this._gxidd);
    }

    protected void updateClientDataFromBranch(byte[] cd, BranchXid bxid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals((Xid)((Object)bxid))) continue;
            cd[i] = (byte)this._bxidds[i].getBranchDecision();
        }
        throw new NoSuchElementException("Branch " + bxid + " not found in global transaction " + this._gxidd);
    }

    protected void updateBranchFromClientData(byte[] cd) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            this._bxidds[i].setBranchDecision(cd[i]);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._gxidd);
        out.writeObject(this._bxidds);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._gxidd = (GlobalXidDecision)in.readObject();
        this._bxidds = (BranchXidDecision[])in.readObject();
        for (int i = 0; i < this._bxidds.length; ++i) {
            this._bxidds[i].getBranchXid().setFormatId(this._gxidd.getGlobalXid().getFormatId());
            this._bxidds[i].getBranchXid().setGlobalTransactionId(this._gxidd.getGlobalXid().getGlobalTransactionId());
        }
    }

    public byte[] toBytes() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        ObjectOutputStream bos = new ObjectOutputStream(baos);
        bos.writeObject(this);
        bos.close();
        return baos.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (i = 0; i < this._bxidds.length; ++i) {
            if (i == 0) {
                sb.append('[');
            }
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this._bxidds[i].toString());
            sb.append(this._bxidds[i].toString());
        }
        if (i > 0) {
            sb.append(']');
        }
        return this._gxidd.toString() + sb.toString();
    }
}

