/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl.manager;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import javax.net.ssl.X509TrustManager;

public class UnifiedX509TrustManager
implements X509TrustManager {
    private final X509TrustManager[] mgrs;
    private final X509Certificate[] issuers;

    public UnifiedX509TrustManager(X509TrustManager[] mgrs) {
        if (mgrs == null) {
            throw new IllegalArgumentException("Null array of X509TrustManagers");
        }
        this.mgrs = mgrs;
        HashSet<X509Certificate> tset = new HashSet<X509Certificate>();
        for (X509TrustManager mgr : mgrs) {
            X509Certificate[] tcerts = mgr.getAcceptedIssuers();
            if (tcerts == null || tcerts.length <= 0) continue;
            for (X509Certificate tcert : tcerts) {
                tset.add(tcert);
            }
        }
        this.issuers = new X509Certificate[tset.size()];
        Iterator iter = tset.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.issuers[i] = (X509Certificate)iter.next();
            ++i;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        CertificateException cex = null;
        for (X509TrustManager mgr : this.mgrs) {
            try {
                cex = null;
                mgr.checkClientTrusted(chain, authType);
                break;
            }
            catch (CertificateException ex) {
                cex = ex;
            }
        }
        if (cex != null) {
            throw cex;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        CertificateException cex = null;
        for (X509TrustManager mgr : this.mgrs) {
            try {
                cex = null;
                mgr.checkServerTrusted(chain, authType);
                break;
            }
            catch (CertificateException ex) {
                cex = ex;
            }
        }
        if (cex != null) {
            throw cex;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.issuers;
    }
}

