/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanCreator;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanDisposer;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticObserver;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.weld.bootstrap.events.AfterBeanDiscoveryImpl;
import org.jboss.weld.lite.extension.translator.AnnotationBuilderFactoryImpl;
import org.jboss.weld.lite.extension.translator.BuildCompatibleExtensionLoader;
import org.jboss.weld.lite.extension.translator.BuildServicesImpl;
import org.jboss.weld.lite.extension.translator.ExtensionInvoker;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseDiscovery;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseEnhancement;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseEnhancementAction;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseRegistration;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseRegistrationAction;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseSynthesis;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseValidation;
import org.jboss.weld.lite.extension.translator.MetaAnnotationsImpl;
import org.jboss.weld.lite.extension.translator.ParametersImpl;
import org.jboss.weld.lite.extension.translator.ReflectionMembers;
import org.jboss.weld.lite.extension.translator.SharedErrors;
import org.jboss.weld.lite.extension.translator.SyntheticBeanBuilderImpl;
import org.jboss.weld.lite.extension.translator.SyntheticObserverBuilderImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;

public class LiteExtensionTranslator
implements Extension {
    private final ExtensionInvoker util;
    private final ClassLoader cl;
    private final SharedErrors errors = new SharedErrors();
    private final List<Class<? extends AlterableContext>> contextsToRegister = new ArrayList<Class<? extends AlterableContext>>();
    private final List<ExtensionPhaseEnhancementAction> enhancementActions = new ArrayList<ExtensionPhaseEnhancementAction>();
    private final List<ExtensionPhaseRegistrationAction> registrationActions = new ArrayList<ExtensionPhaseRegistrationAction>();
    private BeanManager bm;

    public LiteExtensionTranslator() {
        this(BuildCompatibleExtensionLoader.getBuildCompatibleExtensions(), Thread.currentThread().getContextClassLoader());
    }

    @Deprecated(forRemoval=true)
    public LiteExtensionTranslator(List<Class<? extends BuildCompatibleExtension>> buildCompatibleExtensions, ClassLoader cl) {
        this((Collection<Class<? extends BuildCompatibleExtension>>)buildCompatibleExtensions, cl);
    }

    public LiteExtensionTranslator(Collection<Class<? extends BuildCompatibleExtension>> buildCompatibleExtensions, ClassLoader cl) {
        this.util = new ExtensionInvoker(buildCompatibleExtensions);
        this.cl = cl;
        BuildCompatibleExtensionLoader.clearDiscoveredExtensions();
    }

    public void discovery(@Priority(value=0x7FFFFFFF) @Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        this.bm = bm;
        BuildServicesImpl.ANN_FACTORY_IMPL_INSTANCE = new AnnotationBuilderFactoryImpl(bm);
        ArrayList stereotypes = new ArrayList();
        ArrayList<MetaAnnotationsImpl.ContextData> contexts = new ArrayList<MetaAnnotationsImpl.ContextData>();
        new ExtensionPhaseDiscovery(bm, this.util, this.errors, bbd, stereotypes, contexts, this.cl).run();
        for (MetaAnnotationsImpl.StereotypeConfigurator stereotypeConfigurator : stereotypes) {
            bbd.addStereotype(stereotypeConfigurator.annotation, stereotypeConfigurator.annotations.toArray(new Annotation[0]));
        }
        for (MetaAnnotationsImpl.ContextData contextData : contexts) {
            boolean isPassivating;
            boolean isNormal;
            Class<? extends Annotation> scopeAnnotation = contextData.scopeAnnotation;
            if (scopeAnnotation == null) {
                try {
                    scopeAnnotation = contextData.contextClass.getConstructor(new Class[0]).newInstance(new Object[0]).getScope();
                }
                catch (InvocationTargetException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(contextData.contextClass, e.getCause().toString(), e);
                }
                catch (ReflectiveOperationException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(contextData.contextClass, e.toString(), e);
                }
            }
            if (contextData.isNormal != null) {
                isNormal = contextData.isNormal;
                isPassivating = false;
            } else {
                NormalScope normalScope = scopeAnnotation.getAnnotation(NormalScope.class);
                if (normalScope != null) {
                    isNormal = true;
                    isPassivating = normalScope.passivating();
                } else {
                    isNormal = false;
                    isPassivating = false;
                }
            }
            bbd.addScope(scopeAnnotation, isNormal, isPassivating);
            Class<? extends AlterableContext> contextClass = contextData.contextClass;
            this.contextsToRegister.add(contextClass);
        }
        new ExtensionPhaseEnhancement(bm, this.util, this.errors, this.enhancementActions).run();
    }

    public void enhancement(@Priority(value=0x7FFFFFFF) @Observes ProcessAnnotatedType<?> pat) {
        for (ExtensionPhaseEnhancementAction enhancementAction : this.enhancementActions) {
            enhancementAction.run(pat);
        }
    }

    public void registration(@Priority(value=0x7FFFFFFF) @Observes AfterTypeDiscovery atd) {
        new ExtensionPhaseRegistration(this.bm, this.util, this.errors, this.registrationActions).run();
    }

    public void collectBeans(@Priority(value=0x7FFFFFFF) @Observes ProcessBean<?> pb) {
        for (ExtensionPhaseRegistrationAction registrationAction : this.registrationActions) {
            registrationAction.run(pb);
        }
    }

    public void collectObservers(@Priority(value=0x7FFFFFFF) @Observes ProcessObserverMethod<?, ?> pom) {
        for (ExtensionPhaseRegistrationAction registrationAction : this.registrationActions) {
            registrationAction.run(pom);
        }
    }

    public void synthesis(@Priority(value=0x7FFFFFFF) @Observes AfterBeanDiscovery abd) {
        BeanConfigurator<Object> configurator;
        for (Class<? extends AlterableContext> contextClass : this.contextsToRegister) {
            try {
                abd.addContext(contextClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(contextClass, e.getCause().toString(), e);
            }
            catch (ReflectiveOperationException e) {
                throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(contextClass, e.toString(), e);
            }
        }
        ArrayList syntheticBeans = new ArrayList();
        ArrayList syntheticObservers = new ArrayList();
        new ExtensionPhaseSynthesis(this.bm, this.util, this.errors, syntheticBeans, syntheticObservers).run();
        for (SyntheticBeanBuilderImpl syntheticBeanBuilderImpl : syntheticBeans) {
            configurator = abd instanceof AfterBeanDiscoveryImpl ? ((AfterBeanDiscoveryImpl)abd).addBean(syntheticBeanBuilderImpl.extensionClass, LiteExtensionTranslator.class) : abd.addBean();
            configurator.beanClass(syntheticBeanBuilderImpl.implementationClass);
            configurator.types(syntheticBeanBuilderImpl.types);
            configurator.qualifiers(syntheticBeanBuilderImpl.qualifiers);
            if (syntheticBeanBuilderImpl.scope != null) {
                configurator.scope(syntheticBeanBuilderImpl.scope);
            }
            configurator.alternative(syntheticBeanBuilderImpl.isAlternative);
            configurator.priority(syntheticBeanBuilderImpl.priority);
            configurator.name(syntheticBeanBuilderImpl.name);
            configurator.stereotypes(syntheticBeanBuilderImpl.stereotypes);
            configurator.produceWith(lookup -> {
                try {
                    SyntheticBeanCreator creator = syntheticBean.creatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    return creator.create((Instance<Object>)lookup, new ParametersImpl(syntheticBean.params));
                }
                catch (InvocationTargetException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(syntheticBean.creatorClass, e.getCause().toString(), e);
                }
                catch (ReflectiveOperationException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(syntheticBean.creatorClass, e.toString(), e);
                }
            });
            if (syntheticBeanBuilderImpl.disposerClass == null) continue;
            configurator.disposeWith((object, lookup) -> {
                try {
                    SyntheticBeanDisposer<Object> disposer = syntheticBean.disposerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    disposer.dispose(object, (Instance<Object>)lookup, new ParametersImpl(syntheticBean.params));
                }
                catch (InvocationTargetException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(syntheticBean.disposerClass, e.getCause().toString(), e);
                }
                catch (ReflectiveOperationException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(syntheticBean.disposerClass, e.toString(), e);
                }
            });
        }
        for (SyntheticObserverBuilderImpl syntheticObserverBuilderImpl : syntheticObservers) {
            configurator = abd.addObserverMethod();
            configurator.beanClass(syntheticObserverBuilderImpl.declaringClass);
            configurator.observedType(syntheticObserverBuilderImpl.eventType);
            configurator.qualifiers(syntheticObserverBuilderImpl.qualifiers);
            configurator.priority(syntheticObserverBuilderImpl.priority);
            configurator.async(syntheticObserverBuilderImpl.isAsync);
            configurator.reception(syntheticObserverBuilderImpl.reception);
            configurator.transactionPhase(syntheticObserverBuilderImpl.transactionPhase);
            configurator.notifyWith(eventContext -> {
                try {
                    SyntheticObserver observer = syntheticObserver.observerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    observer.observe(eventContext, new ParametersImpl(syntheticObserver.params));
                }
                catch (InvocationTargetException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(syntheticObserver.observerClass, e.getCause().toString(), e);
                }
                catch (ReflectiveOperationException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(syntheticObserver.observerClass, e.toString(), e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validation(@Priority(value=0x7FFFFFFF) @Observes AfterDeploymentValidation adv) {
        try {
            new ExtensionPhaseValidation(this.bm, this.util, this.errors).run();
            for (Throwable error : this.errors.list) {
                adv.addDeploymentProblem(error);
            }
        }
        finally {
            this.util.clear();
            this.errors.list.clear();
            this.contextsToRegister.clear();
            this.enhancementActions.clear();
            this.registrationActions.clear();
            ReflectionMembers.clearCaches();
            this.bm = null;
        }
    }
}

