/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.helper.JavaVersion;

public enum JavaSEPlatform implements Comparable<JavaSEPlatform>
{
    v1_1(1, 1, new Version[0]),
    v1_2(1, 2, new Version[0]),
    v1_3(1, 3, new Version[0]),
    v1_4(1, 4, new Version[0]),
    v1_5(1, 5, new Version[0]),
    v1_6(1, 6, new Version[0]),
    v1_7(1, 7, new Version[0]),
    v1_8(1, 8, new Version[0]),
    v9_0(9, 0, new Version(1, 9)),
    v10_0(10, 0, new Version[0]),
    v11_0(11, 0, new Version[0]),
    v12_0(12, 0, new Version[0]),
    v13_0(13, 0, new Version[0]),
    v14_0(14, 0, new Version[0]);

    private static final Map<String, JavaSEPlatform> stringValuesMap;
    public static final int LENGTH;
    public static final JavaSEPlatform MIN_SUPPORTED;
    static final JavaSEPlatform LATEST;
    public static final JavaSEPlatform CURRENT;
    private final Version version;
    private final Version[] addVersions;

    public static boolean is(JavaSEPlatform platform) {
        return CURRENT.equals(platform);
    }

    public static boolean atLeast(JavaSEPlatform platform) {
        return CURRENT.gte(platform);
    }

    public static JavaSEPlatform toValue(String platformName) {
        if (platformName != null) {
            return stringValuesMap.get(platformName);
        }
        return null;
    }

    public static JavaSEPlatform toValue(int major, int minor) {
        return switch (major) {
            case 1 -> {
                switch (minor) {
                    case 1: {
                        yield v1_1;
                    }
                    case 2: {
                        yield v1_2;
                    }
                    case 3: {
                        yield v1_3;
                    }
                    case 4: {
                        yield v1_4;
                    }
                    case 5: {
                        yield v1_5;
                    }
                    case 6: {
                        yield v1_6;
                    }
                    case 7: {
                        yield v1_7;
                    }
                    case 8: {
                        yield v1_8;
                    }
                    case 9: {
                        yield v9_0;
                    }
                }
                yield LATEST;
            }
            case 9 -> v9_0;
            case 10 -> v10_0;
            case 11 -> v11_0;
            case 12 -> v12_0;
            case 13 -> v13_0;
            case 14 -> v14_0;
            default -> LATEST;
        };
    }

    public static final String versionString(int major, int minor) {
        StringBuilder sb = new StringBuilder(4);
        sb.append(major);
        sb.append('.');
        sb.append(minor);
        return sb.toString();
    }

    private JavaSEPlatform(int major, int minor, Version ... addVersions) {
        this.version = new Version(major, minor);
        this.addVersions = addVersions;
    }

    public final int getMajor() {
        return this.version.major;
    }

    public final int getMinor() {
        return this.version.minor;
    }

    public final Version[] getAdditionalVersions() {
        return this.addVersions;
    }

    public boolean gte(JavaSEPlatform platform) {
        return this.compareTo(platform) >= 0;
    }

    public boolean isSupported() {
        return this.compareTo(MIN_SUPPORTED) >= 0;
    }

    public String versionString() {
        return JavaSEPlatform.versionString(this.version.major, this.version.minor);
    }

    public String toString() {
        return JavaSEPlatform.versionString(this.version.major, this.version.minor);
    }

    static {
        stringValuesMap = new HashMap<String, JavaSEPlatform>(JavaSEPlatform.values().length);
        for (JavaSEPlatform platform : JavaSEPlatform.values()) {
            stringValuesMap.put(platform.versionString(), platform);
            Version[] additional = platform.getAdditionalVersions();
            if (additional == null) continue;
            for (Version version : additional) {
                stringValuesMap.put(version.versionString(), platform);
            }
        }
        LENGTH = JavaSEPlatform.values().length;
        MIN_SUPPORTED = v1_8;
        LATEST = v14_0;
        CURRENT = JavaVersion.vmVersion().toPlatform();
    }

    public static final class Version {
        private final int major;
        private final int minor;

        private Version(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public String versionString() {
            return JavaSEPlatform.versionString(this.major, this.minor);
        }

        public String toString() {
            return JavaSEPlatform.versionString(this.major, this.minor);
        }
    }
}

