/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClassPathBuilder
implements Iterable<File> {
    private final List<File> elements = new ArrayList<File>();

    @Override
    public Iterator<File> iterator() {
        return this.elements.iterator();
    }

    public ClassPathBuilder add(File f) {
        this.elements.add(f);
        return this;
    }

    public ClassPathBuilder add(File f, String ... pathFragments) {
        for (String p : pathFragments) {
            f = new File(f, p);
        }
        return this.add(f);
    }

    public ClassPathBuilder addAll(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            this.addAll(files);
        }
        return this;
    }

    public ClassPathBuilder addAll(File ... files) {
        for (File f : files) {
            this.add(f);
        }
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (File f : this.elements) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(f.getAbsolutePath());
        }
        return buf.toString();
    }
}

