/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LocalTransaction
extends BaseTransaction {
    public LocalTransaction() {
        super(1);
    }

    public LocalTransaction(TransactionUID id, int state, JMQXid xid, TransactionWork txnWork) {
        super(1);
        this.setTransactionWork(txnWork);
        this.transactionDetails.setTid(id);
        this.transactionDetails.setState(state);
        this.transactionDetails.setXid(xid);
    }

    @Override
    public void readData(DataInputStream dis) throws IOException, BrokerException {
        this.transactionDetails.readContent(dis);
        if (this.transactionWork == null) {
            this.transactionWork = new TransactionWork();
        }
        this.transactionWork.readWork(dis);
    }

    @Override
    public void readObjects(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.transactionState = (TransactionState)ois.readObject();
        try {
            this.transactionState.setState(this.transactionDetails.getState());
        }
        catch (BrokerException e) {
            System.getLogger(this.getClass().getName()).log(System.Logger.Level.ERROR, e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void writeData(DataOutputStream dos) throws IOException {
        this.transactionDetails.writeContent(dos);
        this.transactionWork.writeWork(dos);
    }

    @Override
    public void writeObjects(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.transactionState);
    }

    @Override
    String getPrefix() {
        return "LocalTransaction: " + Thread.currentThread().getName() + " " + String.valueOf(this.getTid());
    }
}

