/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.MajorNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class GroupByNode
extends MajorNode {
    List<Node> groupByItems = null;

    public void validate(ParseTreeContext context, SelectNode selectNode) {
        for (Node item : this.groupByItems) {
            item.validate(context);
        }
    }

    public void addGroupingToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            for (Node nextNode : this.getGroupByItems()) {
                ((ReportQuery)theQuery).addGrouping(nextNode.generateExpression(context));
            }
        }
    }

    public boolean isValidHavingExpr(Node expr) {
        if (expr.isDotNode() || expr.isVariableNode()) {
            return this.isGroupbyItem(expr);
        }
        Node left = expr.getLeft();
        Node right = expr.getRight();
        return !(left != null && !this.isValidHavingExpr(left) || right != null && !this.isValidHavingExpr(right));
    }

    private boolean isGroupbyItem(Node expr) {
        if (expr.isDotNode() || expr.isVariableNode()) {
            String exprRepr = expr.getAsString();
            for (Node item : this.groupByItems) {
                String itemRepr = item.getAsString();
                if (!exprRepr.equals(itemRepr)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Node> getGroupByItems() {
        if (this.groupByItems == null) {
            this.setGroupByItems(new Vector<Node>());
        }
        return this.groupByItems;
    }

    public void setGroupByItems(List<Node> newItems) {
        this.groupByItems = newItems;
    }

    @Override
    public String getAsString() {
        StringBuilder repr = new StringBuilder();
        for (Node expr : this.groupByItems) {
            if (!repr.isEmpty()) {
                repr.append(", ");
            }
            repr.append(expr.getAsString());
        }
        return "GROUP BY " + String.valueOf(repr);
    }
}

