/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.osgi.EmbeddedOSGiGlassFishRuntime;
import com.sun.enterprise.glassfish.bootstrap.osgi.EmbeddedOSGiGlassFishRuntimeBuilder;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.main.jul.JULHelperFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class GlassFishMainActivator
implements BundleActivator {
    private static final System.Logger LOG = JULHelperFactory.getHelper().getSystemLogger(GlassFishMainActivator.class);
    private static final String[] DEFAULT_INSTALLATION_LOCATIONS_RELATIVE = new String[]{"modules/", "modules/autostart/"};
    private static final String[] DEFAULT_START_LOCATIONS_RELATIVE = new String[]{"modules/osgi-resource-locator.jar", "modules/osgi-adapter.jar", "modules/autostart/"};
    private GlassFishRuntime gfr;
    private GlassFish gf;
    private boolean embedded;
    private String installRoot;

    public void start(BundleContext context) throws Exception {
        this.embedded = context.getProperty("GlassFish.BUILDER_NAME") == null;
        LOG.log(System.Logger.Level.DEBUG, "Starting {0}; embedded: {1}", context.getBundle(), this.embedded);
        if (this.embedded) {
            this.startEmbedded(context);
        } else {
            this.startNonEmbedded(context);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (!this.embedded) {
            LOG.log(System.Logger.Level.DEBUG, "We are in non-embedded mode, so {0} has nothing to do.", context.getBundle());
            return;
        }
        try {
            if (this.gf != null && this.gf.getStatus() != GlassFish.Status.DISPOSED) {
                this.gf.dispose();
            }
        }
        finally {
            this.gf = null;
        }
        if (this.gfr != null) {
            this.gfr.shutdown();
            this.gfr = null;
        }
    }

    private void startNonEmbedded(BundleContext context) {
        EmbeddedOSGiGlassFishRuntime embeddedGfr = new EmbeddedOSGiGlassFishRuntime(context);
        context.registerService(GlassFishRuntime.class.getName(), (Object)embeddedGfr, null);
        LOG.log(System.Logger.Level.DEBUG, "Registered {0} in service registry.", new Object[]{embeddedGfr});
    }

    private void startEmbedded(BundleContext context) throws GlassFishException {
        Properties properties = this.prepareStartupContext(context);
        BootstrapProperties bsProperties = new BootstrapProperties(properties);
        System.out.println(GlassFishRuntime.class + " is loaded by [" + GlassFishRuntime.class.getClassLoader() + "]");
        GlassFishRuntime existingGfr = this.lookupGfr(context);
        if (existingGfr == null) {
            LOG.log(System.Logger.Level.DEBUG, "Bootstrapping a new GlassFishRuntime");
            existingGfr = this.gfr = GlassFishRuntime.bootstrap((BootstrapProperties)bsProperties, (ClassLoader)this.getClass().getClassLoader());
        } else {
            LOG.log(System.Logger.Level.DEBUG, "Starting existing GlassFishRuntime: [{0}]", existingGfr);
        }
        this.gf = existingGfr.newGlassFish(new GlassFishProperties(properties));
        this.gf.start();
    }

    private GlassFishRuntime lookupGfr(BundleContext context) {
        if (context == null) {
            return null;
        }
        ServiceReference serviceReference = context.getServiceReference(GlassFishRuntime.class.getName());
        return serviceReference == null ? null : (GlassFishRuntime)context.getService(serviceReference);
    }

    private Properties prepareStartupContext(BundleContext context) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        for (String key : properties.stringPropertyNames()) {
            String value = context.getProperty(key);
            if (value == null || value.equals(System.getProperty(key))) continue;
            properties.setProperty(key, value);
        }
        this.installRoot = context.getProperty("com.sun.aas.installRoot");
        if (this.installRoot == null) {
            this.installRoot = this.guessInstallRoot(context);
            if (this.installRoot == null) {
                throw new RuntimeException("Property named com.sun.aas.installRoot is not set.");
            }
            LOG.log(System.Logger.Level.DEBUG, "Deduced install root as: {0} from location of bundle. If this is not correct, set correct value in a property called com.sun.aas.installRoot", this.installRoot);
        }
        if (!new File(this.installRoot).exists()) {
            throw new RuntimeException("No such directory: [" + this.installRoot + "]");
        }
        properties.setProperty("com.sun.aas.installRoot", this.installRoot);
        String instanceRoot = context.getProperty("com.sun.aas.instanceRoot");
        if (instanceRoot == null) {
            instanceRoot = new File(this.installRoot, "domains/domain1/").getAbsolutePath();
        }
        properties.setProperty("com.sun.aas.instanceRoot", instanceRoot);
        properties.putAll((Map<?, ?>)this.makeProvisioningOptions(context));
        properties.setProperty("GlassFish.BUILDER_NAME", EmbeddedOSGiGlassFishRuntimeBuilder.class.getName());
        return properties;
    }

    private String guessInstallRoot(BundleContext context) {
        String location = context.getBundle().getLocation();
        try {
            URI uri = URI.create(location);
            File f = new File(uri);
            if (f.exists() && f.isFile() && f.getParentFile().toPath().endsWith(Path.of("modules", new String[0]))) {
                return f.getParentFile().getParentFile().getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Properties makeProvisioningOptions(BundleContext context) {
        Properties provisioningOptions = new Properties();
        URI installURI = new File(this.installRoot).toURI();
        String installLocations = context.getProperty("glassfish.osgi.auto.install");
        if (installLocations == null) {
            StringBuilder defaultInstallLocations = new StringBuilder();
            for (String entry : DEFAULT_INSTALLATION_LOCATIONS_RELATIVE) {
                defaultInstallLocations.append(installURI.resolve(entry)).append(' ');
            }
            installLocations = defaultInstallLocations.toString();
        }
        provisioningOptions.setProperty("glassfish.osgi.auto.install", installLocations);
        String startLocations = context.getProperty("glassfish.osgi.auto.start");
        if (startLocations == null) {
            StringBuilder defaultStartLocations = new StringBuilder();
            for (String entry : DEFAULT_START_LOCATIONS_RELATIVE) {
                defaultStartLocations.append(installURI.resolve(entry)).append(' ');
            }
            startLocations = defaultStartLocations.toString();
        }
        provisioningOptions.setProperty("glassfish.osgi.auto.start", startLocations);
        LOG.log(System.Logger.Level.DEBUG, "Provisioning options are {0}", provisioningOptions);
        return provisioningOptions;
    }
}

