/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.common;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.persistence.common.I18NHelper;
import org.glassfish.persistence.common.PersistenceHelper;
import org.glassfish.persistence.common.database.DBVendorTypeHelper;

public class Java2DBProcessorHelper {
    private static final Logger logger = LogDomains.getLogger(Java2DBProcessorHelper.class, (String)"jakarta.org.glassfish.persistence");
    private static final ResourceBundle messages = I18NHelper.loadBundle("org.glassfish.persistence.common.LogStrings", Java2DBProcessorHelper.class.getClassLoader());
    private static final String DEFAULT_NAME = "default";
    private static final String APPLICATION_NAME = "org.glassfish.persistence.app_name_property";
    private static final String PROCESSOR_TYPE = "org.glassfish.persistence.processor_type.";
    private static final String RESOURCE_JNDI_NAME = "org.glassfish.persistence.resource_jndi_name_property.";
    private static final String JDBC_FILE_LOCATION = "org.glassfish.persistence.jdbc_file_location_property.";
    private static final String CREATE_JDBC_FILE_NAME = "org.glassfish.persistence.create_jdbc_file_name_property.";
    private static final String DROP_JDBC_FILE_NAME = "org.glassfish.persistence.drop_jdbc_file_name_property.";
    private static final String CREATE_TABLE_VALUE = "org.glassfish.persistence.create_table_value_property.";
    private static final String DROP_TABLE_VALUE = "org.glassfish.persistence.drop_table_value_property.";
    private DeploymentContext ctx;
    private Properties deploymentContextProps;
    private ActionReport subReport;
    private boolean deploy;
    private Boolean cliCreateTables;
    private Boolean cliDropAndCreateTables;
    private Boolean cliDropTables;
    private String appRegisteredName;
    private String appDeployedLocation;
    private String appGeneratedLocation;

    public Java2DBProcessorHelper(String appName) {
        this.appRegisteredName = appName;
    }

    public Java2DBProcessorHelper(DeploymentContext ctx) {
        this.ctx = ctx;
        OpsParams params = ctx.getCommandParameters(OpsParams.class);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> Origin: " + params.origin);
        }
        this.deploy = params.origin.isDeploy();
        this.deploymentContextProps = ctx.getModuleProps();
    }

    public void init() {
        DeployCommandParameters cliOverrides;
        if (this.deploy) {
            cliOverrides = (DeployCommandParameters)this.ctx.getCommandParameters(DeployCommandParameters.class);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("---> cliOverrides " + cliOverrides);
            }
            this.cliCreateTables = cliOverrides.createtables;
            this.cliDropAndCreateTables = cliOverrides.dropandcreatetables;
            Application application = (Application)this.ctx.getModuleMetaData(Application.class);
            this.appRegisteredName = application.getRegistrationName();
            this.deploymentContextProps.setProperty(APPLICATION_NAME, this.appRegisteredName);
        } else {
            cliOverrides = (UndeployCommandParameters)this.ctx.getCommandParameters(UndeployCommandParameters.class);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("---> cliOverrides " + (UndeployCommandParameters)cliOverrides);
            }
            this.cliDropTables = cliOverrides.droptables;
            this.appRegisteredName = this.deploymentContextProps.getProperty(APPLICATION_NAME);
        }
        try {
            this.appGeneratedLocation = this.ctx.getScratchDir("ejb").getCanonicalPath() + File.separator;
        }
        catch (Exception e) {
            throw new RuntimeException(I18NHelper.getMessage(messages, "Java2DBProcessorHelper.generatedlocation", this.appRegisteredName), e);
        }
        this.appDeployedLocation = this.ctx.getSource().getURI().getSchemeSpecificPart() + File.separator;
        ActionReport report = this.ctx.getActionReport();
        this.subReport = report.addSubActionsReport();
        this.subReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public void createOrDropTablesInDB(boolean create, String type) {
        for (String key : this.deploymentContextProps.stringPropertyNames()) {
            if (!key.startsWith(PROCESSOR_TYPE)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("---> key " + key);
            }
            if (!this.deploymentContextProps.getProperty(key).equals(type)) continue;
            String bundleName = key.substring(PROCESSOR_TYPE.length());
            SimpleJndiName jndiName = SimpleJndiName.of((String)this.deploymentContextProps.getProperty(RESOURCE_JNDI_NAME + bundleName));
            String fileName = null;
            if (create) {
                if (this.getCreateTables(bundleName)) {
                    fileName = this.deploymentContextProps.getProperty(CREATE_JDBC_FILE_NAME + bundleName);
                }
            } else if (this.getDropTables(bundleName)) {
                fileName = this.deploymentContextProps.getProperty(DROP_JDBC_FILE_NAME + bundleName);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("---> fileName " + fileName);
                logger.fine("---> jndiName " + jndiName);
            }
            if (fileName == null) continue;
            File file = this.getDDLFile(this.getGeneratedLocation(bundleName) + fileName, true);
            if (file.exists()) {
                this.executeDDLStatement(file, jndiName);
            } else {
                this.logI18NWarnMessage(create ? "Java2DBProcessorHelper.cannotcreatetables" : "Java2DBProcessorHelper.cannotdroptables", this.appRegisteredName, fileName, null);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("<---");
        }
    }

    public File getDDLFile(String fileName, boolean deploy) {
        File file = null;
        try {
            file = new File(fileName);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(I18NHelper.getMessage(messages, deploy ? "Java2DBProcessorHelper.createfilename" : "Java2DBProcessorHelper.dropfilename", file.getName()));
            }
        }
        catch (Exception e) {
            this.logI18NWarnMessage("Exception caught in Java2DBProcessorHelper.getDDLFile()", this.appRegisteredName, null, e);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDDLs(File f, Statement sql) throws IOException {
        BufferedReader reader = null;
        StringBuffer warningBuf = new StringBuffer();
        try {
            String s;
            reader = new BufferedReader(new FileReader(f));
            while ((s = reader.readLine()) != null) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(I18NHelper.getMessage(messages, "Java2DBProcessorHelper.executestatement", s));
                    }
                    sql.execute(s);
                }
                catch (SQLException ex) {
                    String msg = this.getI18NMessage("Java2DBProcessorHelper.sqlexception", s, null, ex);
                    logger.warning(msg);
                    warningBuf.append("\n\t").append(msg);
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException s) {}
            }
            if (warningBuf.length() > 0) {
                String warning = this.getI18NMessage("Java2DBProcessorHelper.tablewarning");
                Java2DBProcessorHelper.warnUser(this.subReport, warning + warningBuf.toString());
            }
        }
    }

    public String getDeployedLocation() {
        return this.appDeployedLocation;
    }

    public String getAppRegisteredName() {
        return this.appRegisteredName;
    }

    public String getCreateJdbcFileName(String bundleName) {
        return this.deploymentContextProps.getProperty(CREATE_JDBC_FILE_NAME + bundleName);
    }

    public void setCreateJdbcFileName(String createJdbcFileName, String bundleName) {
        this.deploymentContextProps.setProperty(CREATE_JDBC_FILE_NAME + bundleName, createJdbcFileName);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> org.glassfish.persistence.create_jdbc_file_name_property." + bundleName + " " + createJdbcFileName);
        }
    }

    public String getDropJdbcFileName(String bundleName) {
        return this.deploymentContextProps.getProperty(DROP_JDBC_FILE_NAME + bundleName);
    }

    public void setDropJdbcFileName(String dropJdbcFileName, String bundleName) {
        this.deploymentContextProps.setProperty(DROP_JDBC_FILE_NAME + bundleName, dropJdbcFileName);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> org.glassfish.persistence.drop_jdbc_file_name_property." + bundleName + " " + dropJdbcFileName);
        }
    }

    public String getJndiName(String bundleName) {
        return this.deploymentContextProps.getProperty(RESOURCE_JNDI_NAME + bundleName);
    }

    public void setJndiName(SimpleJndiName jndiName, String bundleName) {
        this.deploymentContextProps.setProperty(RESOURCE_JNDI_NAME + bundleName, jndiName == null ? null : jndiName.toString());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> org.glassfish.persistence.resource_jndi_name_property." + bundleName + " " + jndiName);
        }
    }

    public void setProcessorType(String processorType, String bundleName) {
        this.deploymentContextProps.setProperty(PROCESSOR_TYPE + bundleName, processorType);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> org.glassfish.persistence.processor_type." + bundleName + " " + processorType);
        }
    }

    public String getGeneratedLocation(String bundleName) {
        String userFileLocation = this.deploymentContextProps.getProperty(JDBC_FILE_LOCATION + bundleName);
        return userFileLocation != null ? userFileLocation : this.appGeneratedLocation;
    }

    public void setGeneratedLocation(String generatedLocation, String bundleName) {
        this.deploymentContextProps.setProperty(JDBC_FILE_LOCATION + bundleName, generatedLocation);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> org.glassfish.persistence.jdbc_file_location_property." + bundleName + " " + generatedLocation);
        }
    }

    public boolean hasDeployCliOverrides() {
        return this.cliCreateTables != null || this.cliDropAndCreateTables != null;
    }

    public boolean hasUndeployCliOverrides() {
        return this.cliDropTables != null;
    }

    public boolean getCreateTables(boolean param) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> param " + param);
            logger.fine("---> cliCreateTables " + this.cliCreateTables);
            logger.fine("---> cliDropAndCreateTables " + this.cliDropAndCreateTables);
        }
        return this.cliCreateTables != null && this.cliCreateTables.equals(Boolean.TRUE) || this.cliDropAndCreateTables != null && this.cliDropAndCreateTables.equals(Boolean.TRUE) || this.cliCreateTables == null && this.cliDropAndCreateTables == null && param;
    }

    public boolean getDropTables(boolean param) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> param " + param);
            logger.fine("---> cliDropTables " + this.cliDropTables);
        }
        return this.cliDropTables != null && this.cliDropTables.equals(Boolean.TRUE) || this.cliDropTables == null && param;
    }

    public boolean getCreateTables(String bundleName) {
        return this.getCreateTables(Boolean.valueOf(this.deploymentContextProps.getProperty(CREATE_TABLE_VALUE + bundleName)));
    }

    public void setCreateTablesValue(boolean createTablesValue, String bundleName) {
        this.deploymentContextProps.setProperty(CREATE_TABLE_VALUE + bundleName, "" + createTablesValue);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> org.glassfish.persistence.create_table_value_property." + bundleName + " " + createTablesValue);
        }
    }

    public boolean getDropTables(String bundleName) {
        return this.getDropTables(Boolean.valueOf(this.deploymentContextProps.getProperty(DROP_TABLE_VALUE + bundleName)));
    }

    public void setDropTablesValue(boolean dropTablesValue, String bundleName) {
        this.deploymentContextProps.setProperty(DROP_TABLE_VALUE + bundleName, "" + dropTablesValue);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---> org.glassfish.persistence.drop_table_value_property." + bundleName + " " + dropTablesValue);
        }
    }

    public static String getDDLNamePrefix(Object info) {
        StringBuffer rc = new StringBuffer();
        if (info instanceof BundleDescriptor && !(info instanceof Application)) {
            BundleDescriptor bundle = (BundleDescriptor)info;
            rc.append(bundle.getApplication().getRegistrationName());
            Application application = bundle.getApplication();
            if (!application.isVirtual()) {
                String modulePath = bundle.getModuleDescriptor().getArchiveUri();
                int l = modulePath.length();
                rc.append('_').append(modulePath.substring(0, l - 4));
            }
        }
        return rc.length() == 0 ? DEFAULT_NAME : rc.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeDDLStatement(File fileName, SimpleJndiName resourceName) {
        boolean result = false;
        Connection conn = null;
        Statement sql = null;
        try {
            try {
                conn = this.getConnection(resourceName);
                sql = conn.createStatement();
                result = true;
            }
            catch (Exception ex) {
                this.cannotConnect(resourceName, ex);
            }
            if (result) {
                this.executeDDLs(fileName, sql);
            }
        }
        catch (IOException e) {
            this.fileIOError(this.appRegisteredName, e);
        }
        finally {
            if (sql != null) {
                try {
                    sql.close();
                }
                catch (SQLException sQLException) {}
            }
            this.closeConn(conn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeDDLStatement(String fileNamePrefix, SimpleJndiName resourceName) {
        File file = null;
        Connection conn = null;
        try {
            conn = this.getConnection(resourceName);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            String vendorName = DBVendorTypeHelper.getDBType(dbMetaData.getDatabaseProductName()).toLowerCase(Locale.ENGLISH);
            file = new File(fileNamePrefix + vendorName + ".sql");
            logger.fine("===> File to use: " + file);
        }
        catch (IOException e) {
            this.fileIOError(this.appRegisteredName, e);
        }
        catch (Exception ex) {
            this.cannotConnect(resourceName, ex);
        }
        finally {
            this.closeConn(conn);
        }
        return this.executeDDLStatement(file, resourceName);
    }

    private Connection getConnection(SimpleJndiName jndiName) throws Exception {
        ServiceLocator habitat = Globals.getDefaultHabitat();
        ConnectorRuntime connectorRuntime = (ConnectorRuntime)habitat.getService(ConnectorRuntime.class, new Annotation[0]);
        DataSource ds = PersistenceHelper.lookupNonTxResource(connectorRuntime, this.ctx, jndiName);
        return ds.getConnection();
    }

    private void cannotConnect(SimpleJndiName connName, Throwable ex) {
        this.logI18NWarnMessage("Java2DBProcessorHelper.cannotConnect", connName.toString(), null, ex);
    }

    private void fileIOError(String regName, Throwable ex) {
        this.logI18NWarnMessage("Java2DBProcessorHelper.ioexception", regName, null, ex);
    }

    private void closeConn(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void logI18NWarnMessage(String errorCode, String regName, String fileName, Throwable ex) {
        String msg = this.getI18NMessage(errorCode, regName, fileName, ex);
        logger.warning(msg);
        Java2DBProcessorHelper.warnUser(this.subReport, msg);
    }

    public String getI18NMessage(String errorCode) {
        return this.getI18NMessage(errorCode, null, null, null);
    }

    public String getI18NMessage(String errorCode, String regName, String fileName, Throwable ex) {
        if (ex != null) {
            return I18NHelper.getMessage(messages, errorCode, regName, ex.toString());
        }
        if (fileName != null) {
            return I18NHelper.getMessage(messages, errorCode, regName, fileName);
        }
        return I18NHelper.getMessage(messages, errorCode);
    }

    public static void warnUser(ActionReport report, String msg) {
        if (report != null) {
            StringBuffer sb = new StringBuffer();
            String s = report.getMessage();
            if (s != null) {
                sb.append(s);
            }
            sb.append("\n").append(msg);
            report.setMessage(sb.toString());
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
    }
}

