/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ProfilerImpl {
    Item currItem = null;
    List<Item> items = new ArrayList<Item>();
    int numBegins = 0;
    int numEnds = 0;
    int numActualEnds = 0;

    public void reset() {
        this.currItem = null;
        this.items.clear();
        this.numBegins = 0;
        this.numEnds = 0;
        this.numActualEnds = 0;
    }

    public void beginItem() {
        this.beginItem("No Description");
    }

    public void beginItem(String desc) {
        this.currItem = new Item(desc);
        this.items.add(this.currItem);
        ++this.numBegins;
    }

    public void endItem() {
        ++this.numEnds;
        Item item = this.getLastNotEnded();
        if (item != null) {
            item.end();
        }
        ++this.numActualEnds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nBegins: ").append(this.numBegins).append(", Ends: ").append(this.numEnds).append(", Actual Ends: ").append(this.numActualEnds).append("\n");
        sb.append(Item.getHeader());
        sb.append("\n");
        for (Item item : this.items) {
            sb.append(item.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private Item getLastNotEnded() {
        int index = this.items.size();
        while (--index >= 0) {
            Item item = this.items.get(index);
            if (item.hasEnded()) continue;
            return item;
        }
        return null;
    }

    public static void main(String[] notUsed) {
        ProfilerImpl p = new ProfilerImpl();
        try {
            p.beginItem("first item");
            Thread.sleep(3000L);
            p.beginItem("second item here dude whoa yowser yowser");
            Thread.sleep(1500L);
            p.endItem();
            p.endItem();
            System.out.println("" + p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Item {
        String title;
        long startTime;
        long endTime;
        static int longestTitle = 12;
        private static final Object lock = new Object();
        boolean ended = false;

        Item(String desc) {
            this.title = desc;
            this.endTime = this.startTime = System.currentTimeMillis();
            Item.setLongestTitle(this.title.length());
        }

        boolean hasEnded() {
            return this.ended;
        }

        void end() {
            this.endTime = System.currentTimeMillis();
            this.ended = true;
        }

        public String toString() {
            long finish = this.hasEnded() ? this.endTime : System.currentTimeMillis();
            Object totalTime = "" + (finish - this.startTime);
            if (((String)totalTime).equals("0")) {
                totalTime = "< 1";
            }
            String desc = StringUtils.padRight(this.title, longestTitle + 1);
            Object time = StringUtils.padLeft((String)totalTime, 8);
            if (!this.hasEnded()) {
                time = (String)time + "  ** STILL RUNNING **";
            }
            return desc + (String)time;
        }

        public static String getHeader() {
            return "\n" + StringUtils.padRight("Description", longestTitle + 1) + StringUtils.padLeft("msec", 8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void setLongestTitle(int len) {
            Object object = lock;
            synchronized (object) {
                if (len > longestTitle) {
                    longestTitle = len;
                }
            }
        }
    }
}

